/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.template.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateJsonFileUtil {
    private static final Logger log = LoggerFactory.getLogger(CreateJsonFileUtil.class);
    private static String SPACE = "   ";
    private static String SUFFIX = ".json";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(String jsonString, String fileName, HttpServletResponse response) throws Exception {
        fileName = (String)fileName + SUFFIX;
        OutputStream os = null;
        Writer write = null;
        try {
            response.setContentType("application/octet-stream");
            response.setHeader("content-disposition", "attachement;filename=" + new String(((String)fileName).getBytes("utf-8"), "ISO-8859-1"));
            response.addHeader("Pargam", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
            os = response.getOutputStream();
            write = new OutputStreamWriter(os, "UTF-8");
            write.write(jsonString);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            if (null != write) {
                write.flush();
                write.close();
            }
            if (null != os) {
                os.flush();
                os.close();
            }
        }
    }

    public static String formatJson(String json) {
        StringBuffer result = new StringBuffer();
        int length = json.length();
        int number = 0;
        char key = '\u0000';
        for (int i = 0; i < length; ++i) {
            key = json.charAt(i);
            if (key == '[' || key == '{') {
                if (i - 1 > 0 && json.charAt(i - 1) == ':') {
                    result.append('\n');
                    result.append(CreateJsonFileUtil.indent(number));
                }
                result.append(key);
                result.append('\n');
                result.append(CreateJsonFileUtil.indent(++number));
                continue;
            }
            if (key == ']' || key == '}') {
                result.append('\n');
                result.append(CreateJsonFileUtil.indent(--number));
                result.append(key);
                if (i + 1 >= length || json.charAt(i + 1) == ',') continue;
                result.append('\n');
                continue;
            }
            result.append(key);
        }
        return result.toString();
    }

    private static String indent(int number) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < number; ++i) {
            result.append(SPACE);
        }
        return result.toString();
    }
}

