/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.PageData;
import com.els.api.dto.TableDefineColumnDto;
import com.els.api.dto.TableFieldDto;
import com.els.api.dto.TableInfoDto;
import com.els.api.dto.TableInfoQueryDto;
import com.els.api.dto.TemplateCreateDto;
import com.els.common.api.service.ClassTypeRpcService;
import com.els.common.api.service.TableLoaderRpcService;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.language.entity.I18n;
import com.els.modules.language.service.I18nService;
import com.els.modules.system.entity.ColumnDefine;
import com.els.modules.system.service.ColumnDefineService;
import com.els.modules.system.util.TableFieldUtil;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigItem;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217"})
@RestController
@RequestMapping(value={"/base/columnDefine"})
public class ColumnDefineController
extends BaseController<ColumnDefine, ColumnDefineService> {
    private static final Logger log = LoggerFactory.getLogger(ColumnDefineController.class);
    @Autowired
    private ColumnDefineService columnDefineService;
    @Autowired
    private I18nService i18nService;
    @Autowired
    private ClassTypeRpcService classTypeRpcService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String TABLE_CODE = "%sList";

    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"system#ColumnDefine:list"})
    public Result<?> queryPageList(ColumnDefine columnDefine, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)columnDefine, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.orderByAsc((Object)"sort_order");
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.columnDefineService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6839\u636etableCode\u67e5\u8be2", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6839\u636etableCode\u67e5\u8be2")
    @GetMapping(value={"/listByTableCode"})
    @RequiresPermissions(value={"system#ColumnDefine:base"})
    public Result<?> queryListByTableCode(ColumnDefine columnDefine, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        if (StringUtils.isBlank((String)columnDefine.getTableCode())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_BmAosWxOLVW_14e2f884", (String)"\u8868\u683c\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!"));
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)columnDefine, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.orderByAsc((Object)"sort_order");
        IPage pageList = this.columnDefineService.page((IPage)page, (Wrapper)queryWrapper);
        if (pageList.getRecords().isEmpty()) {
            TenantContext.setTenant((String)"100000");
            queryWrapper = QueryGenerator.initQueryWrapper((Object)columnDefine, (Map)req.getParameterMap());
            pageList = this.columnDefineService.page((IPage)page, (Wrapper)queryWrapper);
            if (pageList.getRecords().isEmpty()) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LYuAEtHetAJIIVHW_1c2e4ea3", (String)"\u672a\u627e\u5230\u4f01\u4e1a\u53ca\u7cfb\u7edf\u7ea7\u5217\u81ea\u5b9a\u4e49\u4fe1\u606f!"));
            }
        }
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7tableCode\u67e5\u8be2(\u9ad8\u7ea7\u67e5\u8be2\u4f7f\u7528)", notes="\u901a\u8fc7tableCode\u67e5\u8be2(\u9ad8\u7ea7\u67e5\u8be2\u4f7f\u7528)")
    @GetMapping(value={"/queryListByTableCode"})
    @RequiresPermissions(value={"system#ColumnDefine:base"})
    public Result<?> queryListByTableCode(@RequestParam(name="tableCode", required=true) String tableCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"table_code", (Object)tableCode);
        queryWrapper.orderByAsc((Object)"sort_order");
        List defineList = this.columnDefineService.list((Wrapper)queryWrapper);
        if (!"cloud".equals(SysUtil.getDeployWay()) && defineList.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)SysUtil.getPurchaseAccount());
            queryWrapper.eq((Object)"table_code", (Object)tableCode);
            queryWrapper.orderByAsc((Object)"sort_order");
            defineList = this.columnDefineService.list((Wrapper)queryWrapper);
        }
        if (defineList.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"table_code", (Object)tableCode);
            queryWrapper.orderByAsc((Object)"sort_order");
            defineList = this.columnDefineService.list((Wrapper)queryWrapper);
        }
        JSONArray result = new JSONArray();
        ArrayList<String> fieldCode = new ArrayList<String>();
        for (ColumnDefine define : defineList) {
            JSONObject object = new JSONObject();
            String s = define.getColumnCode().split("_")[0];
            if (fieldCode.contains(s)) continue;
            fieldCode.add(s);
            object.put("fieldCode", (Object)s);
            object.put("fieldName", (Object)I18nUtil.translate((String)define.getColumnNameI18nKey(), (String)define.getColumnName()));
            object.put("fieldType", (Object)(StrUtil.isBlank((CharSequence)define.getFieldType()) ? "input" : define.getFieldType()));
            object.put("dictCode", (Object)define.getDictCode());
            object.put("extendLink", (Object)define.getExtendLink());
            result.add((Object)object);
        }
        return Result.ok((Object)result);
    }

    @ApiOperation(value="100000\u53f7\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="100000\u53f7\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/sysList"})
    @RequiresPermissions(value={"system#ColumnDefine:sysList"})
    public Result<?> querySysPageList(ColumnDefine columnDefine, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)columnDefine, (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.orderByAsc((Object)"sort_order");
        IPage pageList = this.columnDefineService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6dfb\u52a0", logType=2, operateType=2)
    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6dfb\u52a0", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"system#ColumnDefine:add"})
    public Result<?> add(@RequestBody ColumnDefine columnDefine) {
        if (StringUtils.isBlank((String)columnDefine.getColumnNameI18nKey())) {
            String s = this.i18nService.checkAndAdd(columnDefine.getColumnName(), "field");
            columnDefine.setColumnNameI18nKey(s);
        }
        this.columnDefineService.save(columnDefine);
        return this.commonSuccessResult(2);
    }

    @SrmValidated
    @AutoLog(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u7f16\u8f91", logType=2, operateType=3)
    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u7f16\u8f91", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"system#ColumnDefine:edit"})
    public Result<?> edit(@RequestBody ColumnDefine columnDefine) {
        if (StringUtils.isBlank((String)columnDefine.getColumnNameI18nKey())) {
            String s = this.i18nService.checkAndAdd(columnDefine.getColumnName(), "field");
            columnDefine.setColumnNameI18nKey(s);
        }
        this.columnDefineService.updateById(columnDefine);
        String id = columnDefine.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u6279\u91cf\u751f\u6210\u56fd\u9645\u5316Key", logType=2, operateType=3)
    @ApiOperation(value="\u6279\u91cf\u751f\u6210\u56fd\u9645\u5316Key", notes="\u6279\u91cf\u751f\u6210\u56fd\u9645\u5316Key")
    @PostMapping(value={"/addBatchKey"})
    @RequiresPermissions(value={"system#ColumnDefine:addBatchKey"})
    public Result<?> addBatchKey(@RequestBody HashMap<String, String> data) {
        String temIds = data.get("temIds");
        List<String> idList = Arrays.asList(temIds.split(","));
        Assert.isTrue((!CollectionUtil.isEmpty(idList) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_VRRiFIAHcbLW_eb724e13", (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u5217\u8fdb\u884c\u751f\u6210\uff01"));
        List columnDefineList = this.columnDefineService.listByIds(idList);
        List collect = columnDefineList.parallelStream().filter(item -> org.apache.commons.lang3.StringUtils.isBlank((CharSequence)item.getColumnNameI18nKey())).map(item -> item.getColumnName()).collect(Collectors.toList());
        Map<Object, Object> stringMap = new HashMap();
        if (!CollectionUtils.isEmpty(collect)) {
            List zh = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.i18nService.lambdaQuery().eq(I18n::getLanguage, (Object)"zh")).in(I18n::getI18nValue, collect)).list();
            stringMap = zh.stream().collect(Collectors.toMap(I18n::getI18nValue, I18n::getI18nKey, (key1, key2) -> key2));
        }
        HashMap<String, String> noKeyHashMap = new HashMap<String, String>();
        for (ColumnDefine entity : columnDefineList) {
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entity.getColumnNameI18nKey())) continue;
            if (stringMap.containsKey(entity.getColumnName())) {
                entity.setColumnNameI18nKey((String)stringMap.get(entity.getColumnName()));
                continue;
            }
            String field = this.i18nService.createI18nKey(entity.getColumnName(), "field");
            noKeyHashMap.put(entity.getColumnName(), field);
            entity.setColumnNameI18nKey(field);
        }
        if (!columnDefineList.isEmpty()) {
            this.columnDefineService.updateBatchById(columnDefineList);
        }
        this.i18nService.addOtherKey(noKeyHashMap);
        this.i18nService.delRedisData(TenantContext.getTenant());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5c06100000\u53f7\u7684\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7", logType=2, operateType=2)
    @ApiOperation(value="\u5c06100000\u53f7\u7684\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7", notes="\u5c06100000\u53f7\u7684\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7")
    @PostMapping(value={"/addToEnterpriseLevel"})
    @RequiresPermissions(value={"system#ColumnDefine:addToEnterpriseLevel"})
    public Result<?> addToEnterpriseLevel(@RequestBody HashMap<String, String> map) {
        this.columnDefineService.addToEnterpriseLevel(map);
        return this.commonSuccessResult(2);
    }

    @AutoLog(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u5220\u9664", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"system#ColumnDefine:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.columnDefineService.removeById((Serializable)((Object)id));
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6279\u91cf\u5220\u9664", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"system#ColumnDefine:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.columnDefineService.removeByIds(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u67e5\u8be2", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"system#ColumnDefine:queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ColumnDefine columnDefine = (ColumnDefine)this.columnDefineService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant()));
        return Result.ok((Object)columnDefine);
    }

    private String checkDelete(String value) {
        return "success";
    }

    private String checkExist(String dataId, String value) {
        return "success";
    }

    @GetMapping(value={"/addDictI18nKey"})
    @RequiresPermissions(value={"system#ColumnDefine:addDictI18nKey"})
    public Result<?> addDictI18nKey() {
        this.columnDefineService.addColumnI18nKey();
        return Result.ok((Object)3);
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/createColumnByTableName"})
    public Result<Object> createColumnByTableNames(@RequestBody List<TableInfoQueryDto> dtos) {
        Map<String, List<TableDefineColumnDto>> columnMap = this.queryTableDefineColumn(dtos);
        if (CollectionUtil.isEmpty(columnMap)) {
            return Result.ok((Object)true);
        }
        HashMap columnDefineMap = new HashMap();
        DateTime now = DateUtil.date();
        columnMap.forEach((arg_0, arg_1) -> ColumnDefineController.lambda$createColumnByTableNames$3((Date)now, columnDefineMap, arg_0, arg_1));
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{ColumnDefine::getTableCode});
        wrapper.eq(ColumnDefine::getElsAccount, (Object)"100000");
        wrapper.in(ColumnDefine::getTableCode, columnDefineMap.keySet());
        List list = this.columnDefineService.list((Wrapper)wrapper);
        List<String> existTableCodeList = list.stream().map(ColumnDefine::getTableCode).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(existTableCodeList)) {
            existTableCodeList.forEach(columnDefineMap::remove);
        }
        if (columnDefineMap.isEmpty()) {
            return Result.ok();
        }
        List defineList = columnDefineMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        this.columnDefineService.saveBatch(defineList);
        return Result.ok();
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/generateTemplateConfig"})
    public Result<Object> generateTemplateConfig(@RequestBody List<TableInfoQueryDto> dtos) {
        Map<String, List<TableDefineColumnDto>> columnMap = this.queryTableDefineColumn(dtos);
        if (null == columnMap) {
            return Result.ok();
        }
        return null;
    }

    @ApiOperation(value="\u6dfb\u52a0\u5230\u5217\u81ea\u5b9a\u4e49", notes="\u6dfb\u52a0\u5230\u5217\u81ea\u5b9a\u4e49")
    @PostMapping(value={"/addToDefineColumn"})
    public Result<Object> addToDefineColumn(@RequestBody TemplateCreateDto dto) {
        if (CollectionUtil.isEmpty((Collection)dto.getColumnList())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_ViFWFW_f352d52c", (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01"));
        }
        Map rpcMap = this.classTypeRpcService.getExcelDataLoader((List)Lists.newArrayList((Object[])new String[]{dto.getServiceInstanceId()}));
        if (CollectionUtil.isEmpty((Map)rpcMap)) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u4e0d\u5b58\u5728");
        }
        TableLoaderRpcService rpcService = (TableLoaderRpcService)rpcMap.get(dto.getServiceInstanceId());
        if (null == rpcService || CharSequenceUtil.isEmpty((CharSequence)dto.getHeadTable())) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u4e0d\u5b58\u5728");
        }
        List<TableFieldDto> tableField = this.rpcQueryTableField(rpcService, Collections.singletonList(dto.getHeadTable()));
        if (tableField.isEmpty()) {
            return Result.ok();
        }
        ArrayList<TableDefineColumnDto> defineColumnDtos = new ArrayList<TableDefineColumnDto>();
        for (TableFieldDto fieldDto : tableField) {
            TableDefineColumnDto columnDto = new TableDefineColumnDto();
            columnDto.setFieldName(TableFieldUtil.initialToCapital(fieldDto.getColumnName().toLowerCase()));
            columnDto.setFieldDbName(fieldDto.getColumnName());
            columnDto.setFieldType(TableFieldUtil.getFiledCodeType(fieldDto.getDataType(), fieldDto.getNumericPrecision(), fieldDto.getNumericScale()));
            columnDto.setFieldDbType(TableFieldUtil.initialToCapital(fieldDto.getDataType()));
            columnDto.setPrecision(fieldDto.getNumericPrecision());
            columnDto.setScale(fieldDto.getNumericScale());
            columnDto.setCharacterMaximumLength(fieldDto.getCharacterMaximumLength());
            columnDto.setNullable(fieldDto.getIsNullable());
            columnDto.setFiledComment(StrUtil.isBlank((CharSequence)fieldDto.getColumnComment()) ? columnDto.getFieldName() : fieldDto.getColumnComment());
            TableFieldUtil.initTableField2CodeField(columnDto);
            defineColumnDtos.add(columnDto);
        }
        List needCheckColumnList = defineColumnDtos.stream().filter(x -> dto.getColumnList().contains(x.getFieldDbName())).collect(Collectors.toList());
        String tableCode = CharSequenceUtil.emptyToDefault((CharSequence)dto.getDefineTableCode(), (String)String.format(TABLE_CODE, StrUtil.upperFirst((CharSequence)TableFieldUtil.initialToCapital(dto.getHeadTable()))));
        if (needCheckColumnList.isEmpty()) {
            return Result.ok();
        }
        List columnCodeList = defineColumnDtos.stream().map(TableDefineColumnDto::getFieldName).distinct().collect(Collectors.toList());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{ColumnDefine::getColumnCode});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ColumnDefine::getTableCode, (Object)tableCode)).eq(ColumnDefine::getElsAccount, (Object)"100000")).in(ColumnDefine::getColumnCode, columnCodeList);
        List dbCodeList = this.columnDefineService.list((Wrapper)wrapper);
        List dbColumnCodeList = dbCodeList.stream().map(ColumnDefine::getColumnCode).collect(Collectors.toList());
        int index = 30;
        DateTime now = DateUtil.date();
        ArrayList<ColumnDefine> defineList = new ArrayList<ColumnDefine>();
        for (TableDefineColumnDto column : needCheckColumnList) {
            if (dbColumnCodeList.contains(column.getFieldName())) continue;
            ColumnDefine tem = new ColumnDefine();
            tem.setElsAccount("100000");
            tem.setTableCode(tableCode);
            tem.setColumnCode(column.getFieldName());
            tem.setColumnName(CharSequenceUtil.emptyToDefault((CharSequence)column.getFiledComment(), (String)column.getFieldName()));
            tem.setAlignType("center");
            tem.setFixType("0");
            tem.setFieldType(TableFieldUtil.getDefineColumnFiledType(column.getFieldType()));
            tem.setSortOrder(BigDecimal.valueOf(index++));
            tem.setSort(CommonConstant.YES_1);
            tem.setHidden("0");
            tem.setCreateBy("admin");
            tem.setCreateById("admin");
            tem.setCreateTime((Date)now);
            tem.setUpdateBy("admin");
            tem.setUpdateById("admin");
            tem.setUpdateTime((Date)now);
            double width = (double)tem.getColumnName().length() / 2.0 * 40.0;
            Integer w = (int)width;
            tem.setColumnWidth(w.toString());
            defineList.add(tem);
        }
        if (CollectionUtil.isNotEmpty(defineList)) {
            this.columnDefineService.saveBatch(defineList);
        }
        return Result.ok();
    }

    private Map<String, List<TableDefineColumnDto>> queryTableDefineColumn(List<TableInfoQueryDto> dtos) {
        List instanceIds = dtos.stream().map(TableInfoQueryDto::getServiceInstanceId).collect(Collectors.toList());
        Map rpcMap = this.classTypeRpcService.getExcelDataLoader(instanceIds);
        if (CollectionUtil.isEmpty((Map)rpcMap)) {
            return null;
        }
        ArrayList<TableFieldDto> tableFieldBos = new ArrayList<TableFieldDto>();
        Map tableMap = dtos.stream().collect(Collectors.groupingBy(TableInfoQueryDto::getServiceInstanceId, Collectors.mapping(TableInfoQueryDto::getTableName, Collectors.toList())));
        for (String instance : tableMap.keySet()) {
            List<String> tableList = tableMap.get(instance);
            List<TableFieldDto> fieldDtoList = this.rpcQueryTableField((TableLoaderRpcService)rpcMap.get(instance), tableList);
            tableFieldBos.addAll(fieldDtoList);
        }
        Map<String, List<TableFieldDto>> groupByTableMap = tableFieldBos.stream().collect(Collectors.groupingBy(TableFieldDto::getTableName));
        HashMap<String, List<TableDefineColumnDto>> columnMap = new HashMap<String, List<TableDefineColumnDto>>();
        groupByTableMap.forEach((tableName, columns) -> {
            ArrayList result = Lists.newArrayList();
            for (TableFieldDto dto : columns) {
                TableDefineColumnDto columnDto = new TableDefineColumnDto();
                columnDto.setFieldName(TableFieldUtil.initialToCapital(dto.getColumnName().toLowerCase()));
                columnDto.setFieldDbName(dto.getColumnName());
                columnDto.setFieldType(TableFieldUtil.getFiledCodeType(dto.getDataType(), dto.getNumericPrecision(), dto.getNumericScale()));
                columnDto.setFieldDbType(TableFieldUtil.initialToCapital(dto.getDataType()));
                columnDto.setPrecision(dto.getNumericPrecision());
                columnDto.setScale(dto.getNumericScale());
                columnDto.setCharacterMaximumLength(dto.getCharacterMaximumLength());
                columnDto.setNullable(dto.getIsNullable());
                columnDto.setFiledComment(StrUtil.isBlank((CharSequence)dto.getColumnComment()) ? columnDto.getFieldName() : dto.getColumnComment());
                TableFieldUtil.initTableField2CodeField(columnDto);
                result.add(columnDto);
            }
            columnMap.put((String)tableName, result);
        });
        return columnMap;
    }

    @PostMapping(value={"/queryTableColumnHeadToTemplate"})
    public Result<Object> queryTableColumnHeadToTemplate(@RequestBody List<TableInfoQueryDto> dto) {
        Map<String, List<TableDefineColumnDto>> columnMap = this.queryTableDefineColumn(dto);
        if (null == columnMap) {
            return Result.ok(new ArrayList());
        }
        ArrayList<TemplateConfigHead> result = new ArrayList<TemplateConfigHead>();
        for (TableInfoQueryDto d : dto) {
            List<TableDefineColumnDto> headColumn = columnMap.get(d.getTableName());
            result.addAll(this.buildHeadColumn(headColumn));
        }
        return Result.ok(result);
    }

    @PostMapping(value={"/queryTableColumnItemToTemplate"})
    public Result<Object> queryTableColumnItemToTemplate(@RequestBody List<TableInfoQueryDto> dto) {
        Map<String, List<TableDefineColumnDto>> columnMap = this.queryTableDefineColumn(dto);
        if (null == columnMap) {
            return Result.ok(new ArrayList());
        }
        ArrayList<TemplateConfigItem> result = new ArrayList<TemplateConfigItem>();
        for (TableInfoQueryDto d : dto) {
            List<TableDefineColumnDto> headColumn = columnMap.get(d.getTableName());
            result.addAll(this.buildItemColumn(headColumn, d));
        }
        return Result.ok(result);
    }

    private List<TemplateConfigItem> buildItemColumn(List<TableDefineColumnDto> itemColumn, TableInfoQueryDto createDto) {
        ArrayList<TemplateConfigItem> itemList = new ArrayList<TemplateConfigItem>();
        for (int i = 0; i < itemColumn.size(); ++i) {
            TableDefineColumnDto column = itemColumn.get(i);
            TemplateConfigItem item = new TemplateConfigItem();
            item.setFieldName(column.getFieldName());
            item.setFieldType(TableFieldUtil.getTemplateColumnFiledType(column.getFieldType()));
            item.setFieldLabel(column.getFiledComment());
            item.setSortOrder(i);
            item.setPurchaseEdit("1");
            item.setPurchaseShow("1");
            item.setSaleEdit("0");
            item.setSaleShow("0");
            item.setAudit("0");
            item.setSys("0");
            item.setRequired("0");
            item.setGroupCode(TableFieldUtil.initialToCapital(createDto.getTableName().toLowerCase()) + "List");
            itemList.add(item);
        }
        return itemList;
    }

    private List<TemplateConfigHead> buildHeadColumn(List<TableDefineColumnDto> headColumn) {
        ArrayList headColumnBoList = Lists.newArrayList();
        for (int i = 0; i < headColumn.size(); ++i) {
            TableDefineColumnDto column = headColumn.get(i);
            TemplateConfigHead head = new TemplateConfigHead();
            head.setGroupCode("baseForm");
            head.setFieldName(column.getFieldName());
            head.setFieldType(TableFieldUtil.getTemplateColumnFiledType(column.getFieldType()));
            head.setFieldLabel(CharSequenceUtil.emptyToDefault((CharSequence)column.getFiledComment(), (String)column.getFieldName()));
            head.setSortOrder(i);
            head.setPurchaseEdit("1");
            head.setPurchaseShow("1");
            head.setSaleEdit("0");
            head.setSaleShow("0");
            head.setAudit("0");
            head.setSys("0");
            head.setRequired("0");
            headColumnBoList.add(head);
        }
        return headColumnBoList;
    }

    private PageData<TableInfoDto> rpcQueryTables(TableLoaderRpcService rpcService, TableInfoQueryDto tableInfoDto) {
        PageData tableInfoDtoPageData = new PageData((List)Lists.newArrayList(), 0L);
        try {
            tableInfoDtoPageData = rpcService.queryTables(tableInfoDto);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return tableInfoDtoPageData;
    }

    List<TableFieldDto> rpcQueryTableField(TableLoaderRpcService rpcService, List<String> tableName) {
        ArrayList<TableFieldDto> tableFieldDtos = new ArrayList();
        try {
            tableFieldDtos = rpcService.queryTableField(tableName);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return tableFieldDtos;
    }

    private static /* synthetic */ void lambda$createColumnByTableNames$3(Date now, Map columnDefineMap, String tableName, List columnList) {
        ArrayList<ColumnDefine> defineList = new ArrayList<ColumnDefine>();
        String tableCode = String.format(TABLE_CODE, StrUtil.upperFirst((CharSequence)TableFieldUtil.initialToCapital(tableName)));
        for (int i = 0; i < columnList.size(); ++i) {
            TableDefineColumnDto column = (TableDefineColumnDto)columnList.get(i);
            ColumnDefine tem = new ColumnDefine();
            tem.setElsAccount("100000");
            tem.setTableCode(tableCode);
            tem.setColumnCode(column.getFieldName());
            tem.setColumnName(CharSequenceUtil.emptyToDefault((CharSequence)column.getFiledComment(), (String)column.getFieldName()));
            tem.setAlignType("center");
            tem.setFixType("0");
            tem.setFieldType(TableFieldUtil.getDefineColumnFiledType(column.getFieldType()));
            tem.setSortOrder(BigDecimal.valueOf(i));
            tem.setSort(CommonConstant.YES_1);
            tem.setHidden("0");
            tem.setCreateBy("admin");
            tem.setCreateById("admin");
            tem.setCreateTime(now);
            tem.setUpdateBy("admin");
            tem.setUpdateById("admin");
            tem.setUpdateTime(now);
            double width = (double)tem.getColumnName().length() / 4.0 * 40.0;
            Integer w = (int)width;
            tem.setColumnWidth(w.toString());
            defineList.add(tem);
        }
        columnDefineMap.put(tableCode, defineList);
    }
}

