/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.base.api.service.ElsEmailConfigRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/chatBi"})
public class ChatBiBaseHttpController {
    private static final Logger log = LoggerFactory.getLogger(ChatBiBaseHttpController.class);
    @Resource
    @Lazy
    private TemplateRpcService templateBeanService;
    @Resource
    @Lazy
    private BaseRpcService baseRpcService;
    @Resource
    @Lazy
    private ElsEmailConfigRpcService elsEmailConfigRpcService;

    @RequestMapping(value={"/invoke/{methodCode}"}, method={RequestMethod.POST})
    public Result<?> invoke(@RequestBody JSONObject object, @PathVariable(value="methodCode") String methodCode) {
        if ("queryDictItemsByCode".equals(methodCode)) {
            String dictCode = object.getString("dictCode");
            String elsAccount = object.getString("elsAccount");
            return Result.ok((Object)this.baseRpcService.queryDictItemsByCode(dictCode, elsAccount));
        }
        if ("sendLicenseAlert".equals(methodCode)) {
            String ccEmail = object.getString("ccEmail");
            String expireDate = object.getString("expireDate");
            this.elsEmailConfigRpcService.sendLicenseAlert(ccEmail, expireDate);
            return Result.ok((Object)new JSONObject());
        }
        if ("getTemplateConfig".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String templateNumber = object.getString("templateNumber");
            String templateVersion = object.getString("templateVersion");
            return Result.ok((Object)this.templateBeanService.getConfig(elsAccount, templateNumber, templateVersion));
        }
        if ("getHeadDictMap_1".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String templateNumber = object.getString("templateNumber");
            String templateVersion = object.getString("templateVersion");
            return Result.ok((Object)this.templateBeanService.getHeadDictMap(elsAccount, templateNumber, templateVersion));
        }
        if ("getHeadDictMap_2".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String templateNumber = object.getString("templateNumber");
            String templateVersion = object.getString("templateVersion");
            String groupCode = object.getString("groupCode");
            return Result.ok((Object)this.templateBeanService.getHeadDictMap(elsAccount, templateNumber, templateVersion, groupCode));
        }
        if ("getItemDictMap_1".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String templateNumber = object.getString("templateNumber");
            String templateVersion = object.getString("templateVersion");
            return Result.ok((Object)this.templateBeanService.getItemDictMap(elsAccount, templateNumber, templateVersion));
        }
        if ("getItemDictMap_2".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String templateNumber = object.getString("templateNumber");
            String templateVersion = object.getString("templateVersion");
            String groupCode = object.getString("groupCode");
            return Result.ok((Object)this.templateBeanService.getItemDictMap(elsAccount, templateNumber, templateVersion, groupCode));
        }
        return Result.error((String)"\u4e0d\u5b58\u5728\u7684\u63a5\u53e3\u65b9\u6cd5");
    }
}

