/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.SaleBarcodePoolHead;
import com.els.modules.barcode.entity.SaleBarcodePoolItem;
import com.els.modules.barcode.entity.SaleBarcodePoolRecord;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.service.SaleBarcodePoolHeadService;
import com.els.modules.barcode.service.SaleBarcodePoolItemService;
import com.els.modules.barcode.service.SaleBarcodePoolRecordService;
import com.els.modules.barcode.vo.BarcodeRecordVO;
import com.els.modules.barcode.vo.SaleBarcodePoolHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/barcode/saleBarcodePoolHead"})
@Api(tags={"\u9500\u552e\u6761\u7801\u5e93\u5934\u8868"})
public class SaleBarcodePoolHeadController
extends BaseController<SaleBarcodePoolHead, SaleBarcodePoolHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleBarcodePoolHeadController.class);
    @Autowired
    private SaleBarcodePoolHeadService saleBarcodePoolHeadService;
    @Autowired
    private SaleBarcodePoolItemService saleBarcodePoolItemService;
    @Autowired
    private SaleBarcodePoolRecordService saleBarcodePoolRecordService;

    @RequiresPermissions(value={"barcode#salePool:list"})
    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SaleBarcodePoolHead saleBarcodePoolHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleBarcodePoolHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleBarcodePoolHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @RequiresPermissions(value={"barcode#salePool:changeStatus"})
    @AutoLog(value="\u72b6\u6001\u53d8\u66f4")
    @ApiOperation(value="\u72b6\u6001\u53d8\u66f4", notes="\u72b6\u6001\u53d8\u66f4")
    @PostMapping(value={"/changeStatus"})
    public Result<?> changeStatus(@RequestBody SaleBarcodePoolHeadVO saleBarcodePoolHeadVO) {
        if ("1".equals(saleBarcodePoolHeadVO.getStatusType())) {
            saleBarcodePoolHeadVO.setStatus(SrmEnabledStatusEnum.ENABLED.getValue());
        } else if ("2".equals(saleBarcodePoolHeadVO.getStatusType())) {
            saleBarcodePoolHeadVO.setStatus(SrmEnabledStatusEnum.DISABLED.getValue());
        }
        SaleBarcodePoolHead saleBarcodePoolHead = new SaleBarcodePoolHead();
        BeanUtils.copyProperties((Object)((Object)saleBarcodePoolHeadVO), (Object)((Object)saleBarcodePoolHead));
        this.saleBarcodePoolHeadService.updateById((Object)saleBarcodePoolHead);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"barcode#salePool:detail"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleBarcodePoolHead saleBarcodePoolHead = (SaleBarcodePoolHead)((Object)this.saleBarcodePoolHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SaleBarcodePoolHeadVO saleBarcodePoolHeadVO = new SaleBarcodePoolHeadVO();
        BeanUtils.copyProperties((Object)((Object)saleBarcodePoolHead), (Object)((Object)saleBarcodePoolHeadVO));
        List<SaleBarcodePoolItem> saleBarcodePoolItemList = this.saleBarcodePoolItemService.selectByMainId(id);
        saleBarcodePoolHeadVO.setSaleBarcodePoolItemList(saleBarcodePoolItemList);
        List<SaleBarcodePoolRecord> saleBarcodePoolRecordList = this.saleBarcodePoolRecordService.selectByMainId(id);
        saleBarcodePoolHeadVO.setSaleBarcodePoolRecordList(saleBarcodePoolRecordList);
        return Result.ok((Object)((Object)saleBarcodePoolHeadVO));
    }

    @RequiresPermissions(value={"barcode#salePool:detail"})
    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u6761\u7801\u5e93\u5934\u8868id\u67e5\u8be2\u9500\u552e\u6761\u7801\u5e93\u884c\u8868", notes="\u901a\u8fc7\u9500\u552e\u6761\u7801\u5e93\u5934\u8868id\u67e5\u8be2\u9500\u552e\u6761\u7801\u5e93\u884c\u8868")
    @GetMapping(value={"/querySaleBarcodePoolItemByMainId"})
    public Result<?> querySaleBarcodePoolItemListByMainId(@RequestParam(name="id") String id) {
        List<SaleBarcodePoolItem> saleBarcodePoolItemList = this.saleBarcodePoolItemService.selectByMainId(id);
        return Result.ok(saleBarcodePoolItemList);
    }

    @RequiresPermissions(value={"barcode#salePool:detail"})
    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u6761\u7801\u5e93\u5934\u8868id\u67e5\u8be2\u9500\u552e\u6761\u7801\u5e93\u4f7f\u7528\u8bb0\u5f55\u8868", notes="\u901a\u8fc7\u9500\u552e\u6761\u7801\u5e93\u5934\u8868id\u67e5\u8be2\u9500\u552e\u6761\u7801\u5e93\u4f7f\u7528\u8bb0\u5f55\u8868")
    @GetMapping(value={"/querySaleBarcodePoolRecordByMainId"})
    public Result<?> querySaleBarcodePoolRecordListByMainId(@RequestParam(name="id") String id) {
        List<SaleBarcodePoolRecord> saleBarcodePoolRecordList = this.saleBarcodePoolRecordService.selectByMainId(id);
        return Result.ok(saleBarcodePoolRecordList);
    }

    @RequiresPermissions(value={"barcode#salePool:saveBarcodeRecordByPrint"})
    @ApiOperation(value="\u56de\u5199\u6761\u7801\u8bb0\u5f55\u4fe1\u606f", notes="\u56de\u5199\u6761\u7801\u8bb0\u5f55\u4fe1\u606f")
    @PostMapping(value={"/saveBarcodeRecordByPrint"})
    public Result<?> saveBarcodeRecordByPrint(@RequestBody BarcodeRecordVO barcodeRecordVO) {
        if (StringUtils.isBlank((CharSequence)barcodeRecordVO.getTemplateId())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_templateIdxOLV_b22600c5", (String)"templateId\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StringUtils.isBlank((CharSequence)barcodeRecordVO.getBusinessType())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_businessTypexOLV_1a94ca2a", (String)"businessType\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        this.saleBarcodePoolRecordService.saveBatchBarcodeByPrint(barcodeRecordVO);
        return Result.ok(null);
    }
}

