/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mq.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.base.api.service.MqConsumerRpcService;
import com.els.modules.mq.entity.MqRecord;
import com.els.modules.mq.mapper.MqRecordMapper;
import com.els.modules.mq.rpc.service.MqConsumerExecuteService;
import com.els.modules.mq.service.MqRecordService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MqRecordServiceImpl
extends BaseServiceImpl<MqRecordMapper, MqRecord>
implements MqRecordService {
    private static final Logger log = LoggerFactory.getLogger(MqRecordServiceImpl.class);
    @Resource
    private MqConsumerExecuteService executeService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retry(MqRecord record) {
        MqConsumerRpcService rpcService = this.executeService.getExecuteService(record.getMsgGroup());
        MqRecord update = new MqRecord();
        update.setId(record.getId());
        try {
            rpcService.receive(record.getMsgBody());
            update.setMsgStatus("1");
            update.setErrorInfo("");
        }
        catch (Exception e) {
            log.error("retry error", (Throwable)e);
            update.setMsgStatus("2");
            update.setErrorInfo(e.getMessage());
        }
        finally {
            this.updateById((Object)update);
        }
    }

    @Override
    public void physicalDeleteById(String id) {
        ((MqRecordMapper)this.baseMapper).physicalDeleteById(id);
    }

    @Override
    public void clearRecord(int days) {
        Date currentDate = new Date();
        DateTime clearDate = DateUtil.offsetDay((Date)currentDate, (int)(-days));
        List recordIdList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().select(new String[]{"id"}).lt((Object)"create_time", (Object)clearDate)).eq((Object)"msg_status", (Object)"1"));
        log.info("\u67e5\u8be2\u5230 " + recordIdList.size() + "\u6761\u5f85\u6e05\u7406\u7684\u8bb0\u5f55\uff0c\u5f00\u59cb\u6267\u884c\u6e05\u7406...");
        for (MqRecord record : recordIdList) {
            ((MqRecordMapper)this.baseMapper).physicalDeleteById(record.getId());
        }
    }
}

