/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SysUtil;
import com.els.modules.ai.core.modelStrategy.AiLogicRunStrategy;
import com.els.modules.ai.core.pojo.AiChatAppDto;
import com.els.modules.ai.core.pojo.AiChatDto;
import com.els.modules.ai.core.pojo.AiChatExamplarDto;
import com.els.modules.ai.core.pojo.LlmRequest;
import com.els.modules.ai.core.pojo.LlmResponse;
import com.els.modules.ai.core.pojo.QuestionInfo;
import com.els.modules.ai.core.util.AiBeanFactory;
import com.els.modules.ai.service.AiChatAppService;
import com.els.modules.ai.service.AiChatExamplarService;
import com.els.modules.ai.service.AiChatModelConfigService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class AiRequestService {
    @Resource
    private AiChatAppService aiChatAppService;
    @Resource
    private AiChatModelConfigService aiChatModelConfigService;
    @Resource
    private AiChatExamplarService aiChatExamplarService;

    public LlmResponse runChat(LlmRequest llmRequest) {
        AiChatDto chatConfig = llmRequest.getChatChatConfig();
        if (null == chatConfig) {
            throw new ELSBootException("\u8c03\u7528\u7684APP\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        AiChatAppDto chatAppConfig = llmRequest.getChatAppConfig();
        if (null == chatConfig) {
            chatConfig = this.aiChatAppService.loadAiChatAppByCode(chatConfig.getAppCode(), SysUtil.getLoginUser().getElsAccount());
        }
        chatConfig.setLanguage("zh");
        chatConfig.setCurrentDate(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        QuestionInfo questionInfo = chatConfig.getQuestion();
        if (CharSequenceUtil.isEmpty((CharSequence)questionInfo.getQuestion())) {
            questionInfo.setQuestion(chatAppConfig.getQuestion());
        }
        List<AiChatExamplarDto> chatExamplers = this.aiChatExamplarService.loadExamplersByCode(chatConfig.getAppCode(), SysUtil.getLoginUser().getElsAccount());
        llmRequest.setChatChatConfig(chatConfig);
        llmRequest.setChatAppConfig(chatAppConfig);
        llmRequest.setChatExamplers(chatExamplers);
        AiLogicRunStrategy runStrategy = AiBeanFactory.getAiLogicRunStrategy(chatAppConfig.getModelRunStrategy());
        LlmResponse result = runStrategy.generate(llmRequest);
        result.setQuestion(questionInfo.getQuestion());
        return result;
    }
}

