/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.modelStrategy;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.modules.ai.core.helper.AiChatResponseHelper;
import com.els.modules.ai.core.modelStrategy.AiLogicRunStrategy;
import com.els.modules.ai.core.pojo.AiChatAppDto;
import com.els.modules.ai.core.pojo.AiChatDto;
import com.els.modules.ai.core.pojo.AiChatExamplarDto;
import com.els.modules.ai.core.pojo.LlmRequest;
import com.els.modules.ai.core.pojo.LlmResponse;
import com.els.modules.ai.core.pojo.QuestionInfo;
import com.els.modules.ai.core.util.AiBeanFactory;
import com.google.common.collect.Lists;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.AiServices;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class SimpleAiLogicRunStrategy
extends AiLogicRunStrategy
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SimpleAiLogicRunStrategy.class);
    public static final String INSTRUCTION = "";

    @Override
    String modelRunStrategy() {
        return "simpleAiLogicRunStrategy";
    }

    @Override
    public LlmResponse generate(LlmRequest llmRequest) {
        LlmResponse llmResponse = new LlmResponse();
        AiChatDto chatChatConfig = llmRequest.getChatChatConfig();
        AiChatAppDto chatAppConfig = llmRequest.getChatAppConfig();
        QuestionInfo question = chatChatConfig.getQuestion();
        String questionText = CharSequenceUtil.isEmpty((CharSequence)question.getQuestion()) ? chatAppConfig.getQuestion() : question.getQuestion();
        llmResponse.setQuestion(questionText);
        List<List<AiChatExamplarDto>> exemplarsList = this.promptHelper.getFewShotExemplars(llmRequest);
        AiChatAppDto chatApp = llmRequest.getChatAppConfig();
        if (StringUtils.isEmpty((CharSequence)chatApp.getPromptTemplate())) {
            chatApp.setPromptTemplate(INSTRUCTION);
        }
        ChatLanguageModel chatLanguageModel = this.getChatLanguageModel(chatApp.getAiChatModelConfig());
        AiChatExtractor extractor = (AiChatExtractor)AiServices.create(AiChatExtractor.class, (ChatLanguageModel)chatLanguageModel);
        HashMap<Prompt, List<AiChatExamplarDto>> prompt2Exemplar = new HashMap<Prompt, List<AiChatExamplarDto>>();
        for (List<AiChatExamplarDto> exemplars : exemplarsList) {
            llmRequest.setChatExamplers(exemplars);
            Prompt prompt2 = this.generatePrompt(llmRequest, llmResponse, chatApp);
            prompt2Exemplar.put(prompt2, exemplars);
        }
        ConcurrentHashMap output2Prompt = new ConcurrentHashMap();
        prompt2Exemplar.keySet().parallelStream().forEach(prompt -> {
            AiQuestion s2Sql = extractor.generateResult(prompt.toUserMessage().singleText());
            output2Prompt.put(s2Sql.getResultText(), prompt);
        });
        AiChatResponseHelper responseHelper = AiBeanFactory.getAiChatResponseHelper(chatAppConfig.getModelRunResponseHelper());
        Pair<String, Map<String, Double>> sqlMapPair = responseHelper.selfConsistencyVote(Lists.newArrayList(output2Prompt.keySet()));
        llmResponse.setResultText((String)sqlMapPair.getLeft());
        List usedExemplars = (List)prompt2Exemplar.get(output2Prompt.get(sqlMapPair.getLeft()));
        llmResponse.setResultMap(responseHelper.buildResponseMap(usedExemplars, (Map)sqlMapPair.getRight()));
        return llmResponse;
    }

    private Prompt generatePrompt(LlmRequest llmRequest, LlmResponse llmResponse, AiChatAppDto chatApp) {
        StringBuilder exemplars = new StringBuilder();
        for (AiChatExamplarDto exemplar : llmRequest.getChatExamplers()) {
            String exemplarStr = String.format("\nQuestion:%s,questionSchema:%s,SideInfo:%s,questionResult:%s", exemplar.getQuestion(), exemplar.getQuestionSchema(), exemplar.getSideInfo(), exemplar.getQuestionResult());
            exemplars.append(exemplarStr);
        }
        String questionSchema = this.promptHelper.buildSchemaStr(llmRequest);
        String sideInformation = this.promptHelper.buildSideInformation(llmRequest);
        llmResponse.setQuestionSchema(questionSchema);
        llmResponse.setSideInfo(sideInformation);
        AiChatAppDto chatAppConfig = llmRequest.getChatAppConfig();
        QuestionInfo question = llmRequest.getChatChatConfig().getQuestion();
        String questionText = CharSequenceUtil.isEmpty((CharSequence)question.getQuestion()) ? chatAppConfig.getQuestion() : question.getQuestion();
        HashMap<String, CharSequence> variable = new HashMap<String, CharSequence>();
        variable.put("exemplar", exemplars);
        variable.put("question", questionText);
        variable.put("questionSchema", questionSchema);
        variable.put("information", sideInformation);
        String promptTemplate = chatApp.getPromptTemplate();
        return PromptTemplate.from((String)promptTemplate).apply(variable);
    }

    static interface AiChatExtractor {
        public AiQuestion generateResult(String var1);
    }

    static class AiQuestion {
        @Description(value={"\u56de\u7b54\u7528\u6237\u63d0\u51fa\u7684Question\uff0c\u8fd4\u56deresultText\uff0c\u8bf7\u5c3d\u91cf\u7cbe\u786e\u3002"})
        private String thought;
        @Description(value={"resultText to generate"})
        private String resultText;

        public String getThought() {
            return this.thought;
        }

        public String getResultText() {
            return this.resultText;
        }

        public void setThought(String thought) {
            this.thought = thought;
        }

        public void setResultText(String resultText) {
            this.resultText = resultText;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AiQuestion)) {
                return false;
            }
            AiQuestion other = (AiQuestion)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$thought = this.getThought();
            String other$thought = other.getThought();
            if (this$thought == null ? other$thought != null : !this$thought.equals(other$thought)) {
                return false;
            }
            String this$resultText = this.getResultText();
            String other$resultText = other.getResultText();
            return !(this$resultText == null ? other$resultText != null : !this$resultText.equals(other$resultText));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AiQuestion;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $thought = this.getThought();
            result = result * 59 + ($thought == null ? 43 : $thought.hashCode());
            String $resultText = this.getResultText();
            result = result * 59 + ($resultText == null ? 43 : $resultText.hashCode());
            return result;
        }

        public String toString() {
            return "SimpleAiLogicRunStrategy.AiQuestion(thought=" + this.getThought() + ", resultText=" + this.getResultText() + ")";
        }
    }
}

