/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.controller;

import com.els.common.api.vo.Result;
import com.els.modules.ai.core.AiRequestService;
import com.els.modules.ai.core.pojo.AiChatDto;
import com.els.modules.ai.core.pojo.LlmRequest;
import com.els.modules.ai.core.pojo.QuestionInfo;
import com.els.modules.ai.vo.AiChatRequestDto;
import com.els.modules.base.api.service.AiChatRpcService;
import com.els.modules.system.rpc.service.BaseInvokeAiChatRpcService;
import io.swagger.annotations.Api;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"AI\u5927\u6a21\u578b\u5bf9\u8bdd"})
@RestController
@RequestMapping(value={"/ai"})
public class AiChatController {
    private static final Logger log = LoggerFactory.getLogger(AiChatController.class);
    @Resource
    private AiRequestService aiRequestService;
    @Autowired
    private BaseInvokeAiChatRpcService baseInvokeAiChatRpcService;

    @PostMapping(value={"/chat"})
    public Result<?> query(@RequestBody AiChatRequestDto aiChatRequestDto) throws Exception {
        LlmRequest llmRequest = new LlmRequest();
        QuestionInfo questionInfo = new QuestionInfo();
        questionInfo.setQuestion(aiChatRequestDto.getQuestion());
        questionInfo.setQuestionSchema(aiChatRequestDto.getQuestionSchema());
        AiChatDto chatChatConfig = new AiChatDto();
        chatChatConfig.setAppCode(aiChatRequestDto.getAppCode());
        chatChatConfig.setQuestion(questionInfo);
        llmRequest.setChatChatConfig(chatChatConfig);
        AiChatRpcService aiChatRpcService = this.baseInvokeAiChatRpcService.getAiChatRpcService(aiChatRequestDto.getLoadSchemaBeanImpl());
        Map loadSchemaData = aiChatRpcService.loadSchemaData(aiChatRequestDto.getSchemaParam());
        questionInfo.setQuestionSchemaMap(loadSchemaData);
        return Result.ok((Object)this.aiRequestService.runChat(llmRequest));
    }
}

