/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.helper;

import com.els.modules.ai.core.pojo.AiChatExamplarDto;
import com.els.modules.ai.core.pojo.LlmRequest;
import com.els.modules.ai.core.util.AiUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AiChatPromptHelper {
    private static final Logger log = LoggerFactory.getLogger(AiChatPromptHelper.class);

    public List<List<AiChatExamplarDto>> getFewShotExemplars(LlmRequest llmRequest) {
        List<AiChatExamplarDto> exemplars = llmRequest.getChatExamplers();
        ArrayList<List<AiChatExamplarDto>> results = new ArrayList<List<AiChatExamplarDto>>();
        ArrayList<AiChatExamplarDto> shuffledList = new ArrayList<AiChatExamplarDto>(exemplars);
        Collections.shuffle(shuffledList);
        results.add(shuffledList.subList(0, Math.min(shuffledList.size(), exemplars.size())));
        return results;
    }

    public String buildSideInformation(LlmRequest llmRequest) {
        String currentDate = llmRequest.getChatChatConfig().getCurrentDate();
        ArrayList sideInfos = Lists.newArrayList();
        sideInfos.add(String.format("CurrentDate=[%s]", currentDate));
        return String.join((CharSequence)",", sideInfos);
    }

    public String buildSchemaStr(LlmRequest llmReq) {
        return AiUtil.jsonToMd(llmReq.getChatChatConfig().getQuestion().getQuestionSchema());
    }
}

