/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.modelStrategy;

import com.els.modules.ai.core.helper.AiChatPromptHelper;
import com.els.modules.ai.core.pojo.AiChatModelConfigDto;
import com.els.modules.ai.core.pojo.LlmRequest;
import com.els.modules.ai.core.pojo.LlmResponse;
import com.els.modules.ai.core.provider.AiModelFactory;
import com.els.modules.ai.core.util.AiBeanFactory;
import dev.langchain4j.model.chat.ChatLanguageModel;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public abstract class AiLogicRunStrategy
implements InitializingBean {
    @Resource
    protected AiChatPromptHelper promptHelper;

    abstract String modelRunStrategy();

    public void afterPropertiesSet() throws Exception {
        AiBeanFactory.registerAiLogicRunStrategy(this.modelRunStrategy(), this);
    }

    protected ChatLanguageModel getChatLanguageModel(AiChatModelConfigDto modelConfig) {
        AiModelFactory modelFactory;
        if (modelConfig == null || StringUtils.isBlank((CharSequence)modelConfig.getProvider()) || StringUtils.isBlank((CharSequence)modelConfig.getBaseUrl())) {
            modelConfig = AiChatModelConfigDto.builder().provider("OPEN_AI").baseUrl("https://api.openai.com/v1").apiKey("demo").modelName("gpt-4o-mini").temperature(0.0).timeOut(60L).build();
        }
        if ((modelFactory = AiBeanFactory.getModelFactories(modelConfig.getProvider().toUpperCase())) != null) {
            return modelFactory.createChatModel(modelConfig);
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6a21\u578b" + modelConfig.getProvider());
    }

    public abstract LlmResponse generate(LlmRequest var1);
}

