/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.provider;

import com.els.modules.ai.core.pojo.AiChatModelConfigDto;
import com.els.modules.ai.core.provider.AiModelFactory;
import com.els.modules.ai.core.util.AiBeanFactory;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import java.time.Duration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class OpenAiModelFactory
implements AiModelFactory,
InitializingBean {
    public static final String PROVIDER = "OPEN_AI";

    @Override
    public ChatLanguageModel createChatModel(AiChatModelConfigDto modelConfig) {
        return OpenAiChatModel.builder().baseUrl(modelConfig.getBaseUrl()).modelName(modelConfig.getModelName()).apiKey(modelConfig.keyDecrypt()).temperature(modelConfig.getTemperature()).topP(modelConfig.getTopPn()).maxRetries(modelConfig.getMaxRetries()).timeout(Duration.ofSeconds(modelConfig.getTimeOut())).logRequests(Boolean.valueOf("1".equals(modelConfig.getLogRequests()))).logResponses(Boolean.valueOf("1".equals(modelConfig.getLogResponses()))).build();
    }

    public void afterPropertiesSet() {
        AiBeanFactory.registerModelFactories(PROVIDER, this);
    }
}

