/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.language.entity.I18n;
import com.els.modules.language.service.I18nService;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.DictService;
import com.els.modules.system.vo.DictItemNode;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/dictItem"})
public class DictItemController {
    private static final Logger log = LoggerFactory.getLogger(DictItemController.class);
    @Autowired
    private DictItemService dictItemService;
    @Autowired
    private I18nService i18nService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String CATALOGUE = "sys:cache:dict";

    @RequiresPermissions(value={"dict#dictItem:list"})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<DictItem>> queryPageList(DictItem sysDictItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysDictItem, (Map)req.getParameterMap());
        queryWrapper.orderByAsc((Object)"sort_order");
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.dictItemService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @RequiresPermissions(value={"dict#dictItem:list"})
    @RequestMapping(value={"/listCascader"}, method={RequestMethod.GET})
    public Result<?> listCascader(DictItem sysDictItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysDictItem, (Map)req.getParameterMap());
        queryWrapper.orderByAsc((Object)"sort_order");
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.dictItemService.page((IPage)page, (Wrapper)queryWrapper);
        List<DictItemNode> dictItemNodes = this.dictItemService.laodDictItemTree(pageList.getRecords());
        return Result.ok(dictItemNodes);
    }

    @RequiresPermissions(value={"dict#dictItem:sysList"})
    @RequestMapping(value={"/sysList"}, method={RequestMethod.GET})
    public Result<IPage<DictItem>> querySysPageList(DictItem sysDictItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysDictItem, (Map)req.getParameterMap());
        queryWrapper.orderByAsc((Object)"sort_order");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.dictItemService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @AutoLog(value="\u5b57\u5178\u9879\u914d\u7f6e-\u6dfb\u52a0")
    @RequiresPermissions(value={"dict#dictItem:add"})
    @SrmValidated
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<DictItem> add(@RequestBody DictItem sysDictItem) {
        Result result = new Result();
        try {
            DictService bean = (DictService)SpringContextUtils.getBean(DictService.class);
            Dict byId = null;
            if (bean != null) {
                byId = (Dict)bean.getById((Serializable)((Object)sysDictItem.getDictId()));
            }
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(DictItem::getElsAccount, (Object)TenantContext.getTenant())).eq(DictItem::getDictId, (Object)sysDictItem.getDictId())).eq(DictItem::getItemText, (Object)sysDictItem.getItemText());
            int count = this.dictItemService.count((Wrapper)wrapper);
            if (byId != null && !"cascader".equals(byId.getDictMode()) && count > 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APJCERsIMKeRJC_3b08bb93", (String)"\u5f53\u524d\u5b57\u5178\u914d\u7f6e\u4e2d\u5df2\u5b58\u5728\u540c\u540d\u5b57\u5178"));
            }
            wrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(DictItem::getElsAccount, (Object)TenantContext.getTenant())).eq(DictItem::getDictId, (Object)sysDictItem.getDictId())).eq(DictItem::getItemValue, (Object)sysDictItem.getItemValue());
            count = this.dictItemService.count((Wrapper)wrapper);
            if (count > 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APJCERsIMKeRJC_3b08bb93", (String)"\u5f53\u524d\u5b57\u5178\u914d\u7f6e\u4e2d\u5df2\u5b58\u5728\u540c\u503c\u5b57\u5178"));
            }
            sysDictItem.setCreateTime(new Date());
            String inputkey = sysDictItem.getItemTextI18nKey();
            List zh = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.i18nService.lambdaQuery().eq(I18n::getLanguage, (Object)"zh")).in(I18n::getI18nValue, new Object[]{inputkey})).list();
            Map<String, String> keyMap = zh.stream().collect(Collectors.toMap(I18n::getI18nValue, I18n::getI18nKey));
            HashMap<String, String> nokeyMap = new HashMap<String, String>();
            if (StringUtils.isNotBlank((String)sysDictItem.getItemText()) && StringUtils.isBlank((String)sysDictItem.getItemTextI18nKey())) {
                String s = this.i18nService.checkAndAdd(sysDictItem.getItemText(), "dict");
                sysDictItem.setItemTextI18nKey(s);
            }
            this.i18nService.addOtherKey(nokeyMap);
            this.dictItemService.save(sysDictItem);
            this.cleanRedis(sysDictItem.getDictId(), TenantContext.getTenant());
            result.setResult((Object)sysDictItem);
        }
        catch (Exception e) {
            throw new ELSBootException((Throwable)e);
        }
        return result;
    }

    @AutoLog(value="\u5b57\u5178\u9879\u914d\u7f6e-\u7f16\u8f91")
    @RequiresPermissions(value={"dict#dictItem:edit"})
    @SrmValidated
    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<DictItem> edit(@RequestBody DictItem sysDictItem) {
        Result result = new Result();
        DictItem sysdict = (DictItem)this.dictItemService.getById((Serializable)((Object)sysDictItem.getId()));
        DictService bean = (DictService)SpringContextUtils.getBean(DictService.class);
        Dict byId = null;
        if (bean != null) {
            byId = (Dict)bean.getById((Serializable)((Object)sysDictItem.getDictId()));
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(DictItem::getElsAccount, (Object)TenantContext.getTenant())).eq(DictItem::getDictId, (Object)sysDictItem.getDictId())).eq(DictItem::getItemText, (Object)sysDictItem.getItemText())).ne(DictItem::getId, (Object)sysDictItem.getId());
        int count = this.dictItemService.count((Wrapper)wrapper);
        if (byId != null && !"cascader".equals(byId.getDictMode()) && count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APJCERsIMKeRJC_3b08bb93", (String)"\u5f53\u524d\u5b57\u5178\u914d\u7f6e\u4e2d\u5df2\u5b58\u5728\u540c\u540d\u5b57\u5178"));
        }
        wrapper.clear();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(DictItem::getElsAccount, (Object)TenantContext.getTenant())).eq(DictItem::getDictId, (Object)sysDictItem.getDictId())).eq(DictItem::getItemValue, (Object)sysDictItem.getItemValue())).ne(DictItem::getId, (Object)sysDictItem.getId());
        count = this.dictItemService.count((Wrapper)wrapper);
        if (count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APJCERsIMKeRJC_3afa6802", (String)"\u5f53\u524d\u5b57\u5178\u914d\u7f6e\u4e2d\u5df2\u5b58\u5728\u540c\u503c\u5b57\u5178"));
        }
        if (sysdict == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            String inputkey = sysDictItem.getItemTextI18nKey();
            List zh = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.i18nService.lambdaQuery().eq(I18n::getLanguage, (Object)"zh")).in(I18n::getI18nValue, new Object[]{inputkey})).list();
            Map<String, String> keyMap = zh.stream().collect(Collectors.toMap(I18n::getI18nValue, I18n::getI18nKey));
            HashMap<String, String> nokeyMap = new HashMap<String, String>();
            if (StringUtils.isNotBlank((String)sysDictItem.getItemText()) && StringUtils.isBlank((String)sysDictItem.getItemTextI18nKey())) {
                String s = this.i18nService.checkAndAdd(sysDictItem.getItemText(), "dict");
                sysDictItem.setItemTextI18nKey(s);
            }
            this.i18nService.addOtherKey(nokeyMap);
            sysDictItem.setUpdateTime(new Date());
            boolean ok = this.dictItemService.updateById(sysDictItem);
            if (ok) {
                result.success("\u7f16\u8f91\u6210\u529f!");
            }
            this.cleanRedis(sysDictItem.getDictId(), TenantContext.getTenant());
        }
        return result;
    }

    @AutoLog(value="\u5b57\u5178\u9879\u914d\u7f6e-\u5220\u9664")
    @RequiresPermissions(value={"dict#dictItem:delete"})
    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<DictItem> delete(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        DictItem joinSystem = (DictItem)this.dictItemService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant()));
        String dict_id = null;
        if (joinSystem == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            dict_id = joinSystem.getDictId();
            boolean ok = this.dictItemService.removeById((Serializable)((Object)id));
            if (ok) {
                result.success("\u5220\u9664\u6210\u529f!");
            }
            this.cleanRedis(dict_id, TenantContext.getTenant());
        }
        return result;
    }

    public void cleanRedis(String dict_id, String elsAccount) {
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        Dict dict = this.dictItemService.selectByDictId(dict_id, elsAccount);
        StringBuilder redisKeyPrex = new StringBuilder(CATALOGUE).append(elsAccount).append(":").append(dict.getDictCode());
        this.redisUtil.deleteByPrex(redisKeyPrex.toString());
    }
}

