/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.system.entity.ElsYhBankConfig;
import com.els.modules.system.entity.ElsYhBranchBankConfig;
import com.els.modules.system.entity.ElsYhCityConfig;
import com.els.modules.system.entity.ElsYhProvinceConfig;
import com.els.modules.system.mapper.ElsYhBankConfigMapper;
import com.els.modules.system.mapper.ElsYhBranchBankConfigMapper;
import com.els.modules.system.mapper.ElsYhCityConfigMapper;
import com.els.modules.system.mapper.ElsYhProvinceConfigMapper;
import com.els.modules.system.service.ElsYhBranchBankConfigService;
import com.els.modules.system.vo.ElsYhBranchBankConfigVO;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class ElsYhBranchBankConfigServiceImpl
extends BaseServiceImpl<ElsYhBranchBankConfigMapper, ElsYhBranchBankConfig>
implements ElsYhBranchBankConfigService {
    @Resource
    private ElsYhProvinceConfigMapper elsYhProvinceConfigMapper;
    @Resource
    private ElsYhCityConfigMapper elsYhCityConfigMapper;
    @Resource
    private ElsYhBankConfigMapper elsYhBankConfigMapper;

    private Result checkParam(ElsYhBranchBankConfigVO configVO) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)configVO.getProvinceName()), (String)I18nUtil.translate((String)"i18n_title_provinceCannotBeEmpty", (String)"\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)configVO.getCityName()), (String)I18nUtil.translate((String)"i18n_title_cityCannotBeEmpty", (String)"\u57ce\u5e02\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)configVO.getBankName()), (String)I18nUtil.translate((String)"i18n_alert_WExOLV_d7189b26", (String)"\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)configVO.getBranchCode()), (String)I18nUtil.translate((String)"i18n_alert_WERcAoxOLV_1d9e858e", (String)"\u94f6\u884c\u652f\u884c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)configVO.getBranchName()), (String)I18nUtil.translate((String)"i18n_alert_WERcRLxOLV_c91fa566", (String)"\u94f6\u884c\u652f\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        ElsYhProvinceConfig province = this.elsYhProvinceConfigMapper.selectProvinceConfigByCode(configVO.getProvinceCode());
        Assert.isTrue((!ObjectUtils.isEmpty((Object)((Object)province)) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_bzAojSYxuIdjbzVH_59076a71", (String)"\u7701\u4efd\u7f16\u7801\u6709\u8bef\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7701\u4efd\u4fe1\u606f"));
        ElsYhCityConfig city = this.elsYhCityConfigMapper.selectCityConfigByCode(configVO.getCityCode());
        Assert.isTrue((!ObjectUtils.isEmpty((Object)((Object)city)) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_LKAojSYxuIdjLKVH_9b312971", (String)"\u57ce\u5e02\u7f16\u7801\u6709\u8bef\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u57ce\u5e02\u4fe1\u606f"));
        ElsYhBankConfig bank = this.elsYhBankConfigMapper.selectBankConfigByCode(configVO.getBankCode());
        Assert.isTrue((!ObjectUtils.isEmpty((Object)((Object)bank)) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_WEAojSYxuIdjWEVH_ee9e60b1", (String)"\u94f6\u884c\u7f16\u7801\u6709\u8bef\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u94f6\u884c\u4fe1\u606f"));
        Result result = new Result(province, city, bank);
        return result;
    }

    @Override
    public void add(ElsYhBranchBankConfigVO configVO) {
        Result result = this.checkParam(configVO);
        List<ElsYhBranchBankConfigVO> branchList = ((ElsYhBranchBankConfigMapper)this.baseMapper).selectBranchListByCodeName(configVO.getBranchCode() + "_" + configVO.getBranchName());
        Assert.isTrue((boolean)CollUtil.isEmpty(branchList), (String)I18nUtil.translate((String)"i18n_alert_mWERcIMK_dfb3ea76", (String)"\u6b64\u94f6\u884c\u652f\u884c\u5df2\u5b58\u5728\uff01"));
        ElsYhBranchBankConfig branchBank = new ElsYhBranchBankConfig().setProvinceId(result.province.getId()).setCityId(result.city.getId()).setBankId(result.bank.getId()).setBranchCode(configVO.getBranchCode()).setBranchName(configVO.getBranchName());
        branchBank.setElsAccount("100000");
        ((ElsYhBranchBankConfigMapper)this.baseMapper).insert((Object)branchBank);
        configVO.setId(branchBank.getId());
    }

    @Override
    public void edit(ElsYhBranchBankConfigVO configVO) {
        Result result = this.checkParam(configVO);
        List<ElsYhBranchBankConfigVO> branchList = ((ElsYhBranchBankConfigMapper)this.baseMapper).selectBranchListByCodeName(configVO.getBranchCode() + "_" + configVO.getBranchName());
        if (CollUtil.isNotEmpty(branchList)) {
            long count = branchList.stream().filter(x -> x.getId() == configVO.getId() && x.getBranchCode() == configVO.getBranchCode() && x.getBranchName() == configVO.getBranchName()).count();
            Assert.isTrue((count == 0L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_mWERcIMK_dfb3ea76", (String)"\u6b64\u94f6\u884c\u652f\u884c\u5df2\u5b58\u5728\uff01"));
        }
        ElsYhBranchBankConfig branchBank = new ElsYhBranchBankConfig().setProvinceId(result.province.getId()).setCityId(result.city.getId()).setBankId(result.bank.getId()).setBranchCode(configVO.getBranchCode()).setBranchName(configVO.getBranchName());
        branchBank.setId(configVO.getId());
        branchBank.setElsAccount("100000");
        int count = ((ElsYhBranchBankConfigMapper)this.baseMapper).updateById((Object)branchBank);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public ElsYhBranchBankConfigVO queryById(String id) {
        return ((ElsYhBranchBankConfigMapper)this.baseMapper).selectBranchById(id);
    }

    @Override
    public void delete(String id) {
        ((ElsYhBranchBankConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public IPage<ElsYhBranchBankConfigVO> seleBanksPage(Page<ElsYhBranchBankConfigVO> page, QueryWrapper<ElsYhBranchBankConfigVO> queryWrapper) {
        return ((ElsYhBranchBankConfigMapper)this.baseMapper).seleBanksPage(page, queryWrapper);
    }

    private static class Result {
        public final ElsYhProvinceConfig province;
        public final ElsYhCityConfig city;
        public final ElsYhBankConfig bank;

        public Result(ElsYhProvinceConfig province, ElsYhCityConfig city, ElsYhBankConfig bank) {
            this.province = province;
            this.city = city;
            this.bank = bank;
        }
    }
}

