/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.controller;

import com.els.common.api.vo.Result;
import com.els.modules.ai.core.AiRequestService;
import com.els.modules.ai.core.pojo.AiChatPojo;
import com.els.modules.ai.core.pojo.LlmRequestPojo;
import com.els.modules.ai.core.pojo.QuestionInfoPojo;
import com.els.modules.ai.vo.AiChatRequestDto;
import com.els.modules.base.api.service.AiChatRpcService;
import com.els.modules.system.rpc.service.BaseInvokeAiChatRpcService;
import io.swagger.annotations.Api;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"AI\u5927\u6a21\u578b\u5bf9\u8bdd"})
@RestController
@RequestMapping(value={"/ai"})
public class AiChatController {
    private static final Logger log = LoggerFactory.getLogger(AiChatController.class);
    @Resource
    private AiRequestService aiRequestService;
    @Autowired
    private BaseInvokeAiChatRpcService baseInvokeAiChatRpcService;

    @PostMapping(value={"/chat"})
    public Result<?> query(@RequestBody AiChatRequestDto aiChatRequestDto) throws Exception {
        LlmRequestPojo llmRequest = new LlmRequestPojo();
        QuestionInfoPojo questionInfo = new QuestionInfoPojo();
        questionInfo.setQuestion(aiChatRequestDto.getQuestion());
        questionInfo.setQuestionSchema(aiChatRequestDto.getQuestionSchema());
        questionInfo.setBusinessId(aiChatRequestDto.getBusinessId());
        questionInfo.setBusinessNumber(aiChatRequestDto.getBusinessNumber());
        questionInfo.setBusinessType(aiChatRequestDto.getBusinessType());
        questionInfo.setBusinessName(aiChatRequestDto.getBusinessName());
        AiChatPojo chatChatConfig = new AiChatPojo();
        chatChatConfig.setAppCode(aiChatRequestDto.getAppCode());
        chatChatConfig.setQuestion(questionInfo);
        llmRequest.setAiChatPojo(chatChatConfig);
        AiChatRpcService aiChatRpcService = this.baseInvokeAiChatRpcService.getAiChatRpcService(aiChatRequestDto.getLoadSchemaBeanImpl());
        Map loadSchemaData = aiChatRpcService.loadSchemaData(aiChatRequestDto.getSchemaParam());
        questionInfo.setQuestionSchemaMap(loadSchemaData);
        return Result.ok((Object)this.aiRequestService.runChat(llmRequest));
    }
}

