/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.helper;

import com.els.modules.ai.core.pojo.AiChatExamplarPojo;
import com.els.modules.ai.core.pojo.LlmRequestPojo;
import com.els.modules.ai.core.util.AiUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AiChatPromptHelper {
    private static final Logger log = LoggerFactory.getLogger(AiChatPromptHelper.class);

    public List<List<AiChatExamplarPojo>> getFewShotExemplars(LlmRequestPojo llmRequest) {
        List<AiChatExamplarPojo> exemplars = llmRequest.getChatExamplers();
        ArrayList<List<AiChatExamplarPojo>> results = new ArrayList<List<AiChatExamplarPojo>>();
        ArrayList<AiChatExamplarPojo> shuffledList = new ArrayList<AiChatExamplarPojo>(exemplars);
        Collections.shuffle(shuffledList);
        results.add(shuffledList.subList(0, Math.min(shuffledList.size(), exemplars.size())));
        return results;
    }

    public String buildSideInformation(LlmRequestPojo llmRequest) {
        String currentDate = llmRequest.getAiChatPojo().getCurrentDate();
        ArrayList sideInfos = Lists.newArrayList();
        sideInfos.add(String.format("CurrentDate=[%s]", currentDate));
        return String.join((CharSequence)",", sideInfos);
    }

    public String buildSchemaStr(LlmRequestPojo llmReq) {
        return AiUtil.jsonToMd(llmReq.getAiChatPojo().getQuestion().getQuestionSchema());
    }
}

