/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.encryption;

import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.barcode.encryption.base.BaseEncryption;
import com.els.modules.barcode.encryption.base.IEncryption;
import com.els.modules.barcode.enumerate.I18nBarCodeEnum;
import com.els.modules.barcode.utils.EncodesUtil;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSA
extends BaseEncryption
implements IEncryption {
    private static final String KEY_ALGORITHM = "RSA";
    private static final String BASE64_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCBcK2hcICq+3f42c58DjtIzal3vf4qpdHYhs+lG5woF5DzbPYZXSW4UVRDpu8SnVJ21gIEo9KOl91QKSyicNGH7ZnJFjqUbEJ0OMZMJn9Lj//CqJq9yAvz+9dca1Mg6x5Il6Z4ERn/qnEYd3WrFQyVcwnET52f33g6qESuEm3ifwIDAQAB";
    private static final String BASE64_PRIVATE_KEY = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAIFwraFwgKr7d/jZznwOO0jNqXe9/iql0diGz6UbnCgXkPNs9hldJbhRVEOm7xKdUnbWAgSj0o6X3VApLKJw0YftmckWOpRsQnQ4xkwmf0uP/8Komr3IC/P711xrUyDrHkiXpngRGf+qcRh3dasVDJVzCcRPnZ/feDqoRK4SbeJ/AgMBAAECgYBZpoArs276facPbVONKpI3D3KTo7y5LxYTYPPKSEA0qHXVk58z3Ab3DSVOof0tqFboRbsqGYkJB/fZwFrQu1DzT4m4dbwrlcGqVzKGgUOXHc+Le4JdJngtcD4qF+W2dWFPnDYIdcWLkXqFMC7tgn07w59u1quKxnyoGz5gDa/leQJBAOh3oQyTt+wt+fsvYDJhKcHgpnFslsDlsbFKWF282HDJfPXaB1V97l4Xy6qHyG345jY0MdhglTk+qJslIbHtMhMCQQCOixvozTMPydmZvBcYILlonHR6vFX7HLG4wDOXYEvPfTjhGNcQY2ss4LW6AbvdY/MuoFQ6pDFMna+3tcmdTntlAkEAgCD/uUjqBNlKgXIZWWtIcr35v2aUqPlxOUC699+QhInpwDBN/ocMjPwcm39/r22SpambF6IUXZr1n52VttX/1QJAaV0kTSnY05PVl9CzlW8i/dOgOdUbDRoBuFnCCOPyRbX/JEwTNJb4ctzLF2oOrrAh4lY6zHnvwv1QFNB37iJEDQJBALjnamLcX2h86IN5+n73EbBp0Ih1HFJ2i5kvQaxTBhDZScdDKLlUKy70bNCnLvy99Y4sG5EiuYyxQr1TYTCXGbg=";

    private byte[] getPublicKey() throws Exception {
        return EncodesUtil.decodeBase64(BASE64_PUBLIC_KEY);
    }

    private byte[] getPrivateKey() throws Exception {
        return EncodesUtil.decodeBase64(BASE64_PRIVATE_KEY);
    }

    private byte[] plainTextEncrypt(byte[] plainText) throws Exception {
        byte[] keyBytes = this.getPublicKey();
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, publicKey);
        return cipher.doFinal(plainText);
    }

    public byte[] decryptByPrivateKey(byte[] cipherText) throws Exception {
        byte[] keyBytes = this.getPrivateKey();
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, privateKey);
        return cipher.doFinal(cipherText);
    }

    @Override
    public String plainTextEncrypt(String plainText) {
        try {
            byte[] plainBytes = this.plainTextEncrypt(plainText.getBytes("utf-8"));
            return EncodesUtil.encodeBase64(plainBytes);
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((Enum)I18nBarCodeEnum.ENCRYPTION_ERROR), (Throwable)e, new String[0]);
        }
    }

    @Override
    public String cipherTextDecrypt(String cipherText) {
        try {
            byte[] cipherBytes = EncodesUtil.decodeBase64(cipherText);
            byte[] plainBytes = this.decryptByPrivateKey(cipherBytes);
            return new String(plainBytes, "utf-8");
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((Enum)I18nBarCodeEnum.ENCRYPTION_ERROR), (Throwable)e, new String[0]);
        }
    }
}

