/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.util;

import com.els.modules.ai.core.helper.AiChatResponseHelper;
import com.els.modules.ai.core.modelStrategy.AiLogicRunStrategy;
import com.els.modules.ai.core.provider.AiModelFactory;
import java.util.HashMap;
import java.util.Map;

public class AiBeanFactory {
    private static final Map<String, AiChatResponseHelper> RESPONSE_HELPER_FACTORIES = new HashMap<String, AiChatResponseHelper>();
    private static final Map<String, AiLogicRunStrategy> LOGIN_RUN_FACTORIES = new HashMap<String, AiLogicRunStrategy>();
    private static final Map<String, AiModelFactory> MODEL_FACTORIES = new HashMap<String, AiModelFactory>();

    public static void registerAiChatResponseHelper(String aiBusinessType, AiChatResponseHelper responseHelper) {
        RESPONSE_HELPER_FACTORIES.put(aiBusinessType, responseHelper);
    }

    public static AiChatResponseHelper getAiChatResponseHelper(String aiBusinessType) {
        return RESPONSE_HELPER_FACTORIES.get(aiBusinessType);
    }

    public static void registerAiLogicRunStrategy(String aiBusinessType, AiLogicRunStrategy logicRunStrategy) {
        LOGIN_RUN_FACTORIES.put(aiBusinessType, logicRunStrategy);
    }

    public static AiLogicRunStrategy getAiLogicRunStrategy(String aiBusinessType) {
        return LOGIN_RUN_FACTORIES.get(aiBusinessType);
    }

    public static void registerModelFactories(String provider, AiModelFactory modelFactory) {
        MODEL_FACTORIES.put(provider, modelFactory);
    }

    public static AiModelFactory getModelFactories(String provider) {
        return MODEL_FACTORIES.get(provider);
    }
}

