#!/bin/bash

echo '---------------归档-批量进行-不删除源表数据（适用于公共表）---------------'
<#list itemList as item>
    <#if item.archiverMode == "archiveOnly">
echo $(date +%F%n%T) '【${((item.targetTable!'')?length>0)?string((item.targetTable!''),item.sourceTable)}】表处理开始...'
pt-archiver --source h=${head.sourceHost!},P=${head.sourcePort!},u=${head.sourceUser!},p=${head.sourcePassword!},D=${head.sourceSchema!},t=${item.sourceTable!} --dest h=${head.targetHost!},P=${head.targetPort!},u=${head.targetUser!},p=${head.targetPassword!},D=${head.targetSchema!},t=${((item.targetTable!'')?length>0)?string((item.targetTable!''),item.sourceTable)} --where "1=1" --progress=5000 --txn-size=1000 --limit=10000  --no-delete --no-safe-auto-increment --charset=${((item.charset!'')?length>0)?string((item.charset!''),head.charset)} --statistics
echo $(date +%F%n%T) '【${((item.targetTable!'')?length>0)?string((item.targetTable!''),item.sourceTable)}】表处理完毕！'
echo ''
    </#if>
</#list>
echo ''
echo '---------------归档-批量进行-同时删除源表数据（适用于业务表）---------------'
<#list itemList as item>
    <#if item.archiverMode == "archiveAndDelete">
echo $(date +%F%n%T) '【${((item.targetTable!'')?length>0)?string((item.targetTable!''),item.sourceTable)}】表处理开始...'
pt-archiver --source h=${head.sourceHost!},P=${head.sourcePort!},u=${head.sourceUser!},p=${head.sourcePassword!},D=${head.sourceSchema!},t=${item.sourceTable!} --dest h=${head.targetHost!},P=${head.targetPort!},u=${head.targetUser!},p=${head.targetPassword!},D=${head.targetSchema!},t=${((item.targetTable!'')?length>0)?string((item.targetTable!''),item.sourceTable)} --where "${item.timeField!"create_time"} < '${((item.archiverDate!'')?length>0)?string((item.archiverDate!''),head.archiverDate)}' ${item.extraCondition!''}" --progress=5000 --txn-size=1000 --limit=10000 --no-safe-auto-increment --charset=${((item.charset!'')?length>0)?string((item.charset!''),head.charset)} --statistics <#if head.optimizeTable == "1">--optimize=s</#if>
echo $(date +%F%n%T) '【${((item.targetTable!'')?length>0)?string((item.targetTable!''),item.sourceTable)}】表处理完毕！'
echo ''
    </#if>
</#list>
echo ''
echo '---------------不归档-直接删除-批量删除（适用于日志表）---------------'
<#list itemList as item>
    <#if item.archiverMode == "deleteOnly">
echo $(date +%F%n%T) '【${((item.targetTable!'')?length>0)?string((item.targetTable!''),item.sourceTable)}】表处理开始...'
pt-archiver --source h=${head.sourceHost!},P=${head.sourcePort!},u=${head.sourceUser!},p=${head.sourcePassword!},D=${head.sourceSchema!},t=${item.sourceTable!} --where "${item.timeField!"create_time"} < '${((item.archiverDate!'')?length>0)?string((item.archiverDate!''),head.archiverDate)}' ${item.extraCondition!''}" --progress=5000 --txn-size=1000 --limit=10000 --purge --primary-key-only --charset=${((item.charset!'')?length>0)?string((item.charset!''),head.charset)} --statistics <#if head.optimizeTable == "1">--optimize=s</#if>
echo $(date +%F%n%T) '【${((item.targetTable!'')?length>0)?string((item.targetTable!''),item.sourceTable)}】表处理完毕！'
echo ''
    </#if>
</#list>