/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.modelStrategy.dync;

import com.els.modules.ai.core.modelStrategy.dync.DynamicAiResponseObjConfig;
import dev.langchain4j.model.output.structured.Description;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewConstructor;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;

public class DynamicClassGenerator {
    private static final Map<String, Class<?>> CLASS_CACHE = new ConcurrentHashMap();

    public Class<?> generateResponseClass(DynamicAiResponseObjConfig config) throws CannotCompileException, NotFoundException {
        if (!config.getLastResponseClassName().matches("^com\\.els\\.modules\\.ai\\.core\\.modelStrategy\\.[A-Za-z0-9_]+$")) {
            throw new SecurityException("\u4e0d\u53ef\u7528\u7c7b\u540d");
        }
        return CLASS_CACHE.computeIfAbsent(config.getLastResponseClassName(), className -> {
            try {
                ClassPool pool = ClassPool.getDefault();
                CtClass ctClass = pool.makeClass(className);
                for (Map.Entry<String, String> entry : config.getFieldDescriptions().entrySet()) {
                    CtField field = new CtField(pool.get(String.class.getName()), entry.getKey(), ctClass);
                    ConstPool constPool = ctClass.getClassFile().getConstPool();
                    AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
                    Annotation annot = new Annotation(Description.class.getName(), constPool);
                    annot.addMemberValue("value", (MemberValue)new StringMemberValue(entry.getValue(), constPool));
                    attr.addAnnotation(annot);
                    field.getFieldInfo().addAttribute((AttributeInfo)attr);
                    ctClass.addField(field);
                }
                ctClass.addConstructor(CtNewConstructor.defaultConstructor((CtClass)ctClass));
                return ctClass.toClass();
            }
            catch (Exception e) {
                throw new RuntimeException("Class generation failed", e);
            }
        });
    }
}

