/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.modelStrategy.dync;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.ai.core.modelStrategy.dync.AiEnhanceService;
import com.els.modules.ai.core.pojo.AiChatAppPojo;
import com.els.modules.ai.core.pojo.AiChatModelConfigPojo;
import com.els.modules.ai.core.pojo.AiChatPojo;
import com.els.modules.ai.core.pojo.LlmResponsePojo;
import com.google.common.collect.Lists;
import dev.langchain4j.model.input.Prompt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Service;

@Service(value="qianfanFileAiEnhanceServiceImpl")
public class QianfanFileAiEnhanceServiceImpl
implements AiEnhanceService {
    @Override
    public String runAiRequestParamBuilder(AiChatPojo aiChatPojo, AiChatAppPojo aiChatAppPojo, Prompt prompt) {
        AiChatModelConfigPojo aiChatModelConfigPojo = aiChatAppPojo.getAiChatModelConfigPojo();
        JSONObject param = new JSONObject();
        param.put("model", (Object)aiChatModelConfigPojo.getModelName());
        JSONObject messages = new JSONObject();
        messages.put("role", (Object)"user");
        param.put("messages", (Object)Lists.newArrayList((Object[])new JSONObject[]{messages}));
        param.put("plugins", (Object)Lists.newArrayList((Object[])new String[]{"ChatFilePlus"}));
        param.put("stream", (Object)false);
        JSONObject plugin_options = new JSONObject();
        param.put("plugin_options", (Object)plugin_options);
        JSONObject plugin_args = new JSONObject();
        plugin_options.put("plugin_args", (Object)plugin_args);
        JSONObject ChatFilePlus = new JSONObject();
        plugin_args.put("ChatFilePlus", (Object)ChatFilePlus);
        JSONObject body = new JSONObject();
        ChatFilePlus.put("body", (Object)body);
        ArrayList<List<JSONObject>> files = new ArrayList<List<JSONObject>>();
        files.add(aiChatPojo.getFileList());
        body.put("files", files);
        messages.put("content", (Object)prompt.toUserMessage().singleText());
        return param.toString();
    }

    @Override
    public Map<String, String> runAiRequestHeadBuilder(AiChatPojo aiChatPojo, AiChatAppPojo aiChatAppPojo, Prompt prompt) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Bearer " + aiChatAppPojo.getAiChatModelConfigPojo().getApiKey());
        header.put("Content-Type", "application/json");
        return header;
    }

    @Override
    public LlmResponsePojo runAiSelfConsistencyVoteBuilder(AiChatPojo aiChatPojo, AiChatAppPojo aiChatAppPojo, LlmResponsePojo llmResponse, Map<String, Prompt> output2Prompt) {
        ArrayList outputList = Lists.newArrayList(output2Prompt.keySet());
        HashMap<String, Integer> inputCounts = new HashMap<String, Integer>();
        for (String input : outputList) {
            inputCounts.put(input, inputCounts.getOrDefault(input, 0) + 1);
        }
        String inputMax = null;
        int maxCount = 0;
        int inputSize = outputList.size();
        HashMap<String, Double> votePercentage = new HashMap<String, Double>();
        for (Map.Entry entry : inputCounts.entrySet()) {
            String input = (String)entry.getKey();
            JSONObject jsonObject = JSON.parseObject((String)input);
            input = jsonObject.getJSONArray("choices").getJSONObject(0).getJSONObject("message").getString("content");
            input = JSONObject.parseObject((String)input.replace("```json", "").replace("```", "")).toString();
            int count = (Integer)entry.getValue();
            if (count > maxCount) {
                inputMax = input;
                maxCount = count;
            }
            double percentage = (double)count / (double)inputSize;
            votePercentage.put(input, percentage);
        }
        llmResponse.setResultText((String)Pair.of(inputMax, votePercentage).getLeft());
        return llmResponse;
    }
}

