/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dingtalk.utils;

import com.aliyun.dingtalkoauth2_1_0.Client;
import com.aliyun.dingtalkoauth2_1_0.models.GetAccessTokenRequest;
import com.aliyun.dingtalkoauth2_1_0.models.GetAccessTokenResponse;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.Common;
import com.els.common.util.SpringContextUtils;
import com.els.config.JustAuthConfig;
import java.util.Map;

public class DingTalkOauthUtil {
    public static Client createClient() throws Exception {
        Config config = new Config();
        config.protocol = "https";
        config.regionId = "central";
        return new Client(config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getAccessToken() throws Exception {
        Client client = DingTalkOauthUtil.createClient();
        Map type = ((JustAuthConfig)SpringContextUtils.getBean(JustAuthConfig.class)).getType();
        String clientId = (String)type.get("DINGTALK.client-id");
        String clientSecret = (String)type.get("DINGTALK.client-secret");
        GetAccessTokenRequest getAccessTokenRequest = new GetAccessTokenRequest().setAppKey(clientId).setAppSecret(clientSecret);
        String token = "";
        try {
            GetAccessTokenResponse accessToken = client.getAccessToken(getAccessTokenRequest);
            return accessToken.getBody().getAccessToken();
        }
        catch (TeaException err) {
            if (Common.empty((String)err.code)) return token;
            if (Common.empty((String)err.message)) return token;
        }
        catch (Exception _err) {
            TeaException err = new TeaException(_err.getMessage(), (Throwable)_err);
            if (Common.empty((String)err.code)) return token;
            if (Common.empty((String)err.message)) return token;
        }
        return token;
    }
}

