/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.agent.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.els.modules.ai.agent.core.AgentStrategyFactory;
import com.els.modules.ai.agent.core.vote.VoteStrategy;
import com.els.modules.ai.agent.dto.AgentLlmRequestPojo;
import com.els.modules.ai.agent.entity.AiAgentResultConfigItem;
import com.els.modules.ai.core.pojo.LlmResponsePojo;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataResultRunner {
    private static final Logger log = LoggerFactory.getLogger(DataResultRunner.class);

    public static LlmResponsePojo vote(AgentLlmRequestPojo llmRequest, Map<String, LlmResponsePojo> responsePojoMap, List<AiAgentResultConfigItem> aiAgentResultConfigItemList) {
        List configItems = aiAgentResultConfigItemList.stream().filter(x -> "1".equals(x.getEnable())).sorted(Comparator.comparing(AiAgentResultConfigItem::getOrderSort)).collect(Collectors.toList());
        if (configItems.isEmpty()) {
            return responsePojoMap.values().iterator().next();
        }
        Map<Object, Object> inputMap = new HashMap();
        for (AiAgentResultConfigItem item : aiAgentResultConfigItemList) {
            inputMap = (Map)JSON.parseObject((String)responsePojoMap.toString(), (TypeReference)new TypeReference<Map<String, LlmResponsePojo>>(){}, (Feature[])new Feature[0]);
            VoteStrategy voteStrategy = AgentStrategyFactory.getVoteStrategy(item.getItemType());
            inputMap = voteStrategy.execute(llmRequest, inputMap, item);
        }
        return (LlmResponsePojo)inputMap.values().iterator().next();
    }
}

