/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.agent.core.collect;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.ai.agent.core.AgentStrategyFactory;
import com.els.modules.ai.agent.core.collect.CollectResultStrategy;
import com.els.modules.ai.agent.core.collect.result.AbstractCollectStrategy;
import com.els.modules.ai.agent.dto.AgentLlmRequestPojo;
import com.els.modules.ai.agent.entity.AiAgentDataCollectConfigItem;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Component
public class HttpEngineCollectStrategy
extends AbstractCollectStrategy {
    private static final Logger log = LoggerFactory.getLogger(HttpEngineCollectStrategy.class);

    @Override
    public String type() {
        return "HTTP";
    }

    private static <T> Map<String, T> parseParameterMap(String jsonStr, JSONObject questionQuerySchema, Class<T> clazz) {
        HashMap result = new HashMap();
        if (StrUtil.isBlank((CharSequence)jsonStr)) {
            return result;
        }
        if (null == questionQuerySchema) {
            questionQuerySchema = new JSONObject();
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setRootObject((Object)questionQuerySchema);
        JSONObject paramMap = JSON.parseObject((String)jsonStr);
        paramMap.forEach((arg_0, arg_1) -> HttpEngineCollectStrategy.lambda$parseParameterMap$0((ExpressionParser)parser, result, context, clazz, arg_0, arg_1));
        return result;
    }

    @Override
    public String execute(AgentLlmRequestPojo llmRequest, AiAgentDataCollectConfigItem itemConfig, JSONObject questionQuerySchema) {
        Map<String, String> headers = HttpEngineCollectStrategy.parseParameterMap(itemConfig.getHeaderMapJson(), questionQuerySchema, String.class);
        Map<String, Object> formData = HttpEngineCollectStrategy.parseParameterMap(itemConfig.getFormDataMapJson(), questionQuerySchema, Object.class);
        try {
            Method method = Method.valueOf((String)itemConfig.getRequestMethod());
            HttpResponse execute = ((HttpRequest)HttpUtil.createRequest((Method)method, (String)itemConfig.getUrl()).form(formData).addHeaders(headers)).execute();
            String itemType = itemConfig.getItemType();
            CollectResultStrategy collectResultStrategy = AgentStrategyFactory.getCollectResultStrategy(itemType);
            return collectResultStrategy.execute(itemConfig, execute.body());
        }
        catch (Exception e) {
            log.error("HTTP\u8bf7\u6c42\u5904\u7406\u5f02\u5e38 [{}]", (Object)itemConfig.getName(), (Object)e);
            return "";
        }
    }

    private static /* synthetic */ void lambda$parseParameterMap$0(ExpressionParser parser, Map result, StandardEvaluationContext context, Class clazz, String key, Object value) {
        Expression exp = parser.parseExpression((String)value);
        result.put(key, exp.getValue((EvaluationContext)context, clazz));
    }
}

