/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.agent.core.vote;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.els.modules.ai.agent.core.vote.AbstractVoteStrategy;
import com.els.modules.ai.agent.dto.AgentLlmRequestPojo;
import com.els.modules.ai.agent.entity.AiAgentResultConfigItem;
import com.els.modules.ai.core.pojo.LlmResponsePojo;
import java.util.Map;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JavaScriptEngineVoteStrategy
extends AbstractVoteStrategy {
    private static final Logger log = LoggerFactory.getLogger(JavaScriptEngineVoteStrategy.class);

    @Override
    public String type() {
        return "JAVA_SCRIPT";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, LlmResponsePojo> execute(AgentLlmRequestPojo llmRequest, Map<String, LlmResponsePojo> responsePojoMap, AiAgentResultConfigItem item) {
        try (Context context = Context.newBuilder((String[])new String[]{"js"}).allowHostAccess(HostAccess.newBuilder().allowArrayAccess(true).allowListAccess(true).allowMapAccess(true).build()).allowIO(false).allowCreateThread(false).allowNativeAccess(false).build();){
            Value bindings = context.getBindings("js");
            bindings.putMember("input", responsePojoMap);
            Source scriptSource = Source.newBuilder((String)"js", (CharSequence)item.getItemConfig(), (String)"voteScript.js").build();
            Value result = context.eval(scriptSource);
            if (result.isHostObject()) {
                Map map2 = (Map)result.asHostObject();
                return map2;
            }
            Map map = (Map)JSON.parseObject((String)result.toString(), (TypeReference)new TypeReference<Map<String, LlmResponsePojo>>(){}, (Feature[])new Feature[0]);
            return map;
        }
        catch (Exception e) {
            log.error("\u811a\u672c\u6267\u884c\u5f02\u5e38 | \u914d\u7f6eID:{} | \u9519\u8bef: {}", (Object)item.getId(), (Object)e.getMessage());
            return responsePojoMap;
        }
    }
}

