/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.agent.core.vote;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.modules.ai.agent.core.AgentEnhanceService;
import com.els.modules.ai.agent.core.vote.AbstractVoteStrategy;
import com.els.modules.ai.agent.dto.AgentLlmRequestPojo;
import com.els.modules.ai.agent.entity.AiAgentResultConfigItem;
import com.els.modules.ai.core.modelStrategy.dync.AiEnhanceGroovyFactory;
import com.els.modules.ai.core.pojo.LlmResponsePojo;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceContentEngineVoteStrategy
extends AbstractVoteStrategy {
    private static final Logger log = LoggerFactory.getLogger(ServiceContentEngineVoteStrategy.class);

    @Override
    public String type() {
        return "SERVICE_CONTENT";
    }

    @Override
    public Map<String, LlmResponsePojo> execute(AgentLlmRequestPojo llmRequest, Map<String, LlmResponsePojo> responsePojoMap, AiAgentResultConfigItem item) {
        AgentEnhanceService service;
        String aiInnerEnhanceServiceBean = item.getItemConfig();
        if (CharSequenceUtil.isNotEmpty((CharSequence)aiInnerEnhanceServiceBean) && (service = AiEnhanceGroovyFactory.getInstance().getEnhanceService(aiInnerEnhanceServiceBean, AgentEnhanceService.class)) != null) {
            return service.runVoted(llmRequest, responsePojoMap);
        }
        return responsePojoMap;
    }
}

