/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.agent.collect;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.modules.ai.core.agent.AgentEnhanceService;
import com.els.modules.ai.core.agent.collect.result.AbstractCollectStrategy;
import com.els.modules.ai.dto.AgentLlmRequestPojo;
import com.els.modules.ai.entity.AiAgentDataCollectConfigItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceBeanEngineCollectStrategy
extends AbstractCollectStrategy {
    private static final Logger log = LoggerFactory.getLogger(ServiceBeanEngineCollectStrategy.class);

    @Override
    public String type() {
        return "SERVICE_BEAN";
    }

    @Override
    public String execute(AgentLlmRequestPojo llmRequest, AiAgentDataCollectConfigItem config, JSONObject questionQuerySchema) {
        String cleanConfig = config.getItemConfig();
        if (CharSequenceUtil.isNotEmpty((CharSequence)cleanConfig)) {
            try {
                AgentEnhanceService bean = (AgentEnhanceService)SpringContextUtils.getBean((String)cleanConfig.trim(), AgentEnhanceService.class);
                return bean.runCollect(llmRequest, questionQuerySchema);
            }
            catch (Exception e) {
                throw new ELSBootException(cleanConfig + "\u5b9e\u4f8b\u4e0d\u5b58\u5728");
            }
        }
        return "";
    }
}

