/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.agent.collect;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.ai.core.agent.AgentEnhanceService;
import com.els.modules.ai.core.agent.collect.result.AbstractCollectStrategy;
import com.els.modules.ai.core.modelStrategy.dync.AiEnhanceGroovyFactory;
import com.els.modules.ai.dto.AgentLlmRequestPojo;
import com.els.modules.ai.entity.AiAgentDataCollectConfigItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceContentEngineCollectStrategy
extends AbstractCollectStrategy {
    private static final Logger log = LoggerFactory.getLogger(ServiceContentEngineCollectStrategy.class);

    @Override
    public String type() {
        return "SERVICE_CONTENT";
    }

    @Override
    public String execute(AgentLlmRequestPojo llmRequest, AiAgentDataCollectConfigItem item, JSONObject input) {
        AgentEnhanceService service;
        String aiInnerEnhanceServiceBean = item.getItemConfig();
        if (CharSequenceUtil.isNotEmpty((CharSequence)aiInnerEnhanceServiceBean) && (service = AiEnhanceGroovyFactory.getInstance().getEnhanceService(aiInnerEnhanceServiceBean, AgentEnhanceService.class)) != null) {
            return service.runCollect(llmRequest, input);
        }
        return "";
    }
}

