/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.agent.collect.result;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.modules.ai.core.agent.collect.result.AbstractCollectResultStrategy;
import com.els.modules.ai.entity.AiAgentDataCollectConfigItem;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JavaScriptEngineCollectResultStrategy
extends AbstractCollectResultStrategy {
    private static final Logger log = LoggerFactory.getLogger(JavaScriptEngineCollectResultStrategy.class);

    @Override
    public String type() {
        return "JAVA_SCRIPT";
    }

    @Override
    public String execute(AiAgentDataCollectConfigItem config, String input) {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
        if (engine == null) {
            throw new RuntimeException("Nashorn script engine not found");
        }
        try {
            engine.put("input", input);
            engine.eval(config.getItemConfig());
            if (engine instanceof Invocable) {
                Invocable invocable = (Invocable)((Object)engine);
                Object result = invocable.invokeFunction("collectResultFunction", input);
                if (result instanceof JSONObject) {
                    return ((JSONObject)result).toString();
                }
                if (result instanceof String) {
                    return (String)result;
                }
                return JSON.toJSONString((Object)result);
            }
        }
        catch (Exception e) {
            throw new ELSBootException("\u811a\u672c\u6267\u884c\u5f02\u5e38 | \u914d\u7f6ename:{} | \u9519\u8bef: {}", new String[]{config.getName(), e.getMessage()});
        }
        return input;
    }
}

