/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.agent;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.vo.LoginUser;
import com.els.common.trace.TraceIdHolder;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ai.core.agent.AgentStrategyFactory;
import com.els.modules.ai.core.agent.collect.CollectStrategy;
import com.els.modules.ai.dto.AgentLlmRequestPojo;
import com.els.modules.ai.entity.AiAgentDataCollectConfigItem;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCollectRunner {
    private static final Logger log = LoggerFactory.getLogger(DataCollectRunner.class);

    public static JSONObject collect(AgentLlmRequestPojo llmRequest, List<AiAgentDataCollectConfigItem> aiAgentDataCollectConfigItemList) {
        JSONObject collectDataMap = new JSONObject();
        List configItems = aiAgentDataCollectConfigItemList.stream().filter(x -> "1".equals(x.getEnable())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(configItems)) {
            collectDataMap.put("questionSchema", (Object)llmRequest.getAiChatPojo().getQuestion().getQuestionSchema());
            return collectDataMap;
        }
        JSONObject questionQuerySchema = llmRequest.getAiChatPojo().getQuestion().getQuestionQuerySchema();
        if (null == questionQuerySchema) {
            questionQuerySchema = new JSONObject();
        }
        questionQuerySchema.put("srmToken", (Object)SpringContextUtils.getHttpServletRequest().getHeader("x-access-token"));
        JSONObject finalQuestionQuerySchema = questionQuerySchema;
        String tenant = TenantContext.getTenant();
        String adminFlag = AdminFlagUtil.getAdminFlag();
        LoginUser loginUser = SysUtil.getLoginUser();
        String traceId = TraceIdHolder.get();
        CompletableFuture[] futures = (CompletableFuture[])configItems.stream().map(item -> CompletableFuture.runAsync(() -> {
            try {
                TenantContext.setTenant((String)tenant);
                AdminFlagUtil.setAdminFlag((String)adminFlag);
                LoginUserContext.setUser((LoginUser)loginUser);
                TraceIdHolder.set((String)traceId);
                CollectStrategy collectStrategy = AgentStrategyFactory.getCollectStrategy(item.getRequestType());
                String result = collectStrategy.execute(llmRequest, (AiAgentDataCollectConfigItem)((Object)item), finalQuestionQuerySchema);
                JSONObject jSONObject = collectDataMap;
                synchronized (jSONObject) {
                    collectDataMap.put(item.getName(), (Object)result);
                }
            }
            catch (Exception e) {
                collectDataMap.put(item.getName(), (Object)"");
                log.error("\u6570\u636e\u6536\u96c6\u5904\u7406\u5f02\u5e38 [{}]", (Object)item.getName(), (Object)e);
            }
            finally {
                TenantContext.clear();
                AdminFlagUtil.clear();
                LoginUserContext.clear();
                TraceIdHolder.remove();
            }
        })).toArray(CompletableFuture[]::new);
        try {
            CompletableFuture.allOf(futures).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("\u6570\u636e\u6536\u96c6\u5e76\u884c\u5904\u7406\u5f02\u5e38", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        collectDataMap.put("questionSchema", (Object)llmRequest.getAiChatPojo().getQuestion().getQuestionSchema());
        return collectDataMap;
    }
}

