/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.agent.collect.result;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.ai.core.agent.collect.result.AbstractCollectResultStrategy;
import com.els.modules.ai.dto.AgentLlmRequestPojo;
import com.els.modules.ai.entity.AiAgentDataCollectConfigItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SpelEngineCollectResultStrategy
extends AbstractCollectResultStrategy {
    private static final Logger log = LoggerFactory.getLogger(SpelEngineCollectResultStrategy.class);

    @Override
    public String type() {
        return "SPEL";
    }

    private static <T> T buildSpelValue(JSONObject inputObj, String config, Class<T> clazz) {
        String[] parts = config.split("\\.");
        JSONObject temObj = inputObj;
        for (int i = 0; i <= parts.length - 2; ++i) {
            if (null == temObj) {
                return null;
            }
            temObj = inputObj.getJSONObject(parts[i]);
        }
        if (null == temObj) {
            return null;
        }
        return (T)temObj.getObject(parts[parts.length - 1], clazz);
    }

    @Override
    public String doExecute(AgentLlmRequestPojo llmRequest, AiAgentDataCollectConfigItem config, String body) {
        String spel = config.getItemConfig();
        spel = spel.substring(1, spel.length());
        if ("obj".equals(config.getDataType())) {
            JSONObject jsonObject = JSON.parseObject((String)body);
            return SpelEngineCollectResultStrategy.buildSpelValue(jsonObject, spel, String.class);
        }
        if ("array".equals(config.getDataType())) {
            // empty if block
        }
        return body;
    }
}

