/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.agent.vote;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.els.modules.ai.core.agent.vote.AbstractVoteStrategy;
import com.els.modules.ai.core.pojo.LlmResponsePojo;
import com.els.modules.ai.dto.AgentLlmRequestPojo;
import com.els.modules.ai.entity.AiAgentResultConfigItem;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JavaScriptEngineVoteStrategy
extends AbstractVoteStrategy {
    private static final Logger log = LoggerFactory.getLogger(JavaScriptEngineVoteStrategy.class);

    @Override
    public String type() {
        return "JAVA_SCRIPT";
    }

    @Override
    public Map<String, LlmResponsePojo> doExecute(AgentLlmRequestPojo llmRequest, Map<String, LlmResponsePojo> responsePojoMap, AiAgentResultConfigItem item) {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
        if (engine == null) {
            throw new RuntimeException("Nashorn script engine not found");
        }
        try {
            engine.put("input", responsePojoMap);
            engine.eval(item.getItemConfig());
            if (engine instanceof Invocable) {
                Invocable invocable = (Invocable)((Object)engine);
                Object result = invocable.invokeFunction("javaScriptFunction", responsePojoMap);
                return (Map)JSON.parseObject((String)result.toString(), (TypeReference)new TypeReference<Map<String, LlmResponsePojo>>(){}, (Feature[])new Feature[0]);
            }
        }
        catch (Exception e) {
            log.error("\u811a\u672c\u6267\u884c\u5f02\u5e38 | \u914d\u7f6ename:{} | \u9519\u8bef: {}", (Object)item.getName(), (Object)e.getMessage());
        }
        return responsePojoMap;
    }
}

