/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.agent.vote;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.modules.ai.core.agent.AgentEnhanceService;
import com.els.modules.ai.core.agent.vote.AbstractVoteStrategy;
import com.els.modules.ai.core.modelStrategy.dync.AiEnhanceGroovyFactory;
import com.els.modules.ai.core.pojo.LlmResponsePojo;
import com.els.modules.ai.dto.AgentLlmRequestPojo;
import com.els.modules.ai.entity.AiAgentResultConfigItem;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceContentEngineVoteStrategy
extends AbstractVoteStrategy {
    private static final Logger log = LoggerFactory.getLogger(ServiceContentEngineVoteStrategy.class);

    @Override
    public String type() {
        return "SERVICE_CONTENT";
    }

    @Override
    public Map<String, LlmResponsePojo> doExecute(AgentLlmRequestPojo llmRequest, Map<String, LlmResponsePojo> responsePojoMap, AiAgentResultConfigItem item) {
        AgentEnhanceService service;
        String aiInnerEnhanceServiceBean = item.getItemConfig();
        if (CharSequenceUtil.isNotEmpty((CharSequence)aiInnerEnhanceServiceBean) && (service = AiEnhanceGroovyFactory.getInstance().getEnhanceService(aiInnerEnhanceServiceBean, AgentEnhanceService.class)) != null) {
            return service.runVoted(llmRequest, responsePojoMap);
        }
        return responsePojoMap;
    }
}

