/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.agent;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.trace.TraceIdHolder;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ai.core.agent.AgentStrategyFactory;
import com.els.modules.ai.core.agent.run.RunStrategy;
import com.els.modules.ai.core.pojo.AiChatPojo;
import com.els.modules.ai.core.pojo.LlmRequestPojo;
import com.els.modules.ai.core.pojo.LlmResponsePojo;
import com.els.modules.ai.dto.AgentLlmRequestPojo;
import com.els.modules.ai.entity.AiAgentAppConfigItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAppRunner {
    private static final Logger log = LoggerFactory.getLogger(DataAppRunner.class);

    public static Map<String, LlmResponsePojo> run(AgentLlmRequestPojo llmRequest, Map<String, String> questionSchemaMap, List<AiAgentAppConfigItem> aiAgentAppConfigItemList) {
        List configItems = aiAgentAppConfigItemList.stream().filter(x -> "1".equals(x.getEnable())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(configItems)) {
            throw new ELSBootException("\u8bf7\u5148\u914d\u7f6eAgent\u5e94\u7528\u884c\u6570\u636e");
        }
        llmRequest.getAiChatPojo().getQuestion().setQuestionSchemaMap(questionSchemaMap);
        HashMap<String, LlmResponsePojo> result = new HashMap<String, LlmResponsePojo>();
        String tenant = TenantContext.getTenant();
        String adminFlag = AdminFlagUtil.getAdminFlag();
        LoginUser loginUser = SysUtil.getLoginUser();
        String traceId = TraceIdHolder.get();
        List<CompletableFuture> futures = configItems.stream().map(item -> CompletableFuture.runAsync(() -> {
            try {
                TenantContext.setTenant((String)tenant);
                AdminFlagUtil.setAdminFlag((String)adminFlag);
                LoginUserContext.setUser((LoginUser)loginUser);
                TraceIdHolder.set((String)traceId);
                LlmRequestPojo llmRequestPojo = new LlmRequestPojo();
                llmRequestPojo.setAiChatPojo((AiChatPojo)JSON.parseObject((String)JSON.toJSONString((Object)llmRequest.getAiChatPojo()), AiChatPojo.class));
                llmRequestPojo.getAiChatPojo().setAppCode(item.getAppCode());
                llmRequestPojo.setLogHeadId(llmRequest.getLogHeadId());
                llmRequestPojo.setElsAccount(llmRequest.getElsAccount());
                RunStrategy runStrategy = AgentStrategyFactory.getRunStrategy(StrUtil.emptyToDefault((CharSequence)item.getItemType(), (String)"default"));
                if (null == runStrategy) {
                    throw new ELSBootException("\u5e94\u7528\u8fd0\u884c\u7b56\u7565\u4e0d\u5b58\u5728");
                }
                LlmResponsePojo llmResponsePojo = runStrategy.execute(llmRequestPojo, (AiAgentAppConfigItem)((Object)item));
                Map map = result;
                synchronized (map) {
                    result.put(item.getName() + "_" + item.getOrderSort(), llmResponsePojo);
                }
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u5e94\u7528 {} \u65f6\u51fa\u9519: {}", new Object[]{item.getName(), e.getMessage(), e});
            }
            finally {
                TenantContext.clear();
                AdminFlagUtil.clear();
                LoginUserContext.clear();
                TraceIdHolder.remove();
            }
        })).toList();
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        return result;
    }
}

