/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.agent.collect.result;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.modules.ai.core.agent.AgentEnhanceService;
import com.els.modules.ai.core.agent.collect.result.AbstractCollectResultStrategy;
import com.els.modules.ai.dto.AgentLlmRequestPojo;
import com.els.modules.ai.entity.AiAgentDataCollectConfigItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceBeanEngineCollectResultStrategy
extends AbstractCollectResultStrategy {
    private static final Logger log = LoggerFactory.getLogger(ServiceBeanEngineCollectResultStrategy.class);

    @Override
    public String type() {
        return "SERVICE_BEAN";
    }

    @Override
    public String doExecute(AgentLlmRequestPojo llmRequest, AiAgentDataCollectConfigItem config, String body) {
        String cleanConfig = config.getItemConfig();
        if (CharSequenceUtil.isNotEmpty((CharSequence)cleanConfig)) {
            try {
                AgentEnhanceService bean = (AgentEnhanceService)SpringContextUtils.getBean((String)cleanConfig.trim(), AgentEnhanceService.class);
                return bean.runCollectResult(body);
            }
            catch (Exception e) {
                throw new ELSBootException(cleanConfig + "\u5b9e\u4f8b\u4e0d\u5b58\u5728");
            }
        }
        return body;
    }
}

