/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.agent.vote;

import com.alibaba.fastjson.JSON;
import com.els.modules.ai.core.agent.AgentStrategyFactory;
import com.els.modules.ai.core.agent.vote.VoteStrategy;
import com.els.modules.ai.core.pojo.LlmResponsePojo;
import com.els.modules.ai.dto.AgentLlmRequestPojo;
import com.els.modules.ai.entity.AiAgentResultConfigItem;
import com.els.modules.ai.enums.AgentStepType;
import com.els.modules.ai.listener.AgentMqUtil;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractVoteStrategy
implements VoteStrategy,
InitializingBean {
    public void afterPropertiesSet() throws Exception {
        AgentStrategyFactory.register(this.type(), this);
    }

    public abstract Map<String, LlmResponsePojo> doExecute(AgentLlmRequestPojo var1, Map<String, LlmResponsePojo> var2, AiAgentResultConfigItem var3);

    @Override
    public Map<String, LlmResponsePojo> execute(AgentLlmRequestPojo llmRequest, Map<String, LlmResponsePojo> responsePojoMap, AiAgentResultConfigItem item) {
        try {
            Map<String, LlmResponsePojo> result = this.doExecute(llmRequest, responsePojoMap, item);
            AgentMqUtil.sendItem(llmRequest.getLogHeadId(), llmRequest.getElsAccount(), AgentStepType.RESULT_VOTE.getType(), item.getName(), item.getOrderSort(), JSON.toJSONString(result), "");
            return result;
        }
        catch (Exception e) {
            AgentMqUtil.sendItem(llmRequest.getLogHeadId(), llmRequest.getElsAccount(), AgentStepType.RESULT_VOTE.getType(), item.getName(), item.getOrderSort(), JSON.toJSONString(responsePojoMap), e.getMessage());
            throw e;
        }
    }
}

