/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.agent.vote;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.modules.ai.core.agent.AgentEnhanceService;
import com.els.modules.ai.core.agent.vote.AbstractVoteStrategy;
import com.els.modules.ai.core.pojo.LlmResponsePojo;
import com.els.modules.ai.dto.AgentLlmRequestPojo;
import com.els.modules.ai.entity.AiAgentResultConfigItem;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceBeanEngineVoteStrategy
extends AbstractVoteStrategy {
    private static final Logger log = LoggerFactory.getLogger(ServiceBeanEngineVoteStrategy.class);

    @Override
    public String type() {
        return "SERVICE_BEAN";
    }

    @Override
    public Map<String, LlmResponsePojo> doExecute(AgentLlmRequestPojo llmRequest, Map<String, LlmResponsePojo> responsePojoMap, AiAgentResultConfigItem item) {
        String cleanConfig = item.getItemConfig();
        if (CharSequenceUtil.isNotEmpty((CharSequence)cleanConfig)) {
            try {
                AgentEnhanceService bean = (AgentEnhanceService)SpringContextUtils.getBean((String)cleanConfig, AgentEnhanceService.class);
                return bean.runVoted(llmRequest, responsePojoMap);
            }
            catch (Exception e) {
                throw new ELSBootException(cleanConfig + "\u5b9e\u4f8b\u4e0d\u5b58\u5728");
            }
        }
        return responsePojoMap;
    }
}

