/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ai.core.pojo.LlmResponsePojo;
import com.els.modules.ai.dto.AgentLlmRequestPojo;
import com.els.modules.ai.vo.AiAgentConfigHeadVO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.messaging.support.MessageBuilder;

public class AgentMqUtil {
    private static final Logger log = LoggerFactory.getLogger(AgentMqUtil.class);

    public static void sendHead(String headId, String elsAccount, AgentLlmRequestPojo llmRequest, AiAgentConfigHeadVO agentVo, LlmResponsePojo llmResponsePojo, boolean update) {
        llmRequest.setLogHeadId(headId);
        llmRequest.setElsAccount(elsAccount);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)headId);
        jsonObject.put("elsAccount", (Object)TenantContext.getTenant());
        jsonObject.put("update", (Object)update);
        jsonObject.put("agentCode", (Object)agentVo.getAgentCode());
        jsonObject.put("agentName", (Object)agentVo.getAgentName());
        jsonObject.put("questionInput", (Object)llmRequest.getAiChatPojo().getQuestion().getQuestion());
        jsonObject.put("questionResult", (Object)"");
        if (null != llmResponsePojo) {
            jsonObject.put("questionInput", (Object)llmResponsePojo.getQuestionInput());
            jsonObject.put("questionResult", (Object)llmResponsePojo.getResultText());
        }
        jsonObject.put("businessType", (Object)llmRequest.getAiChatPojo().getQuestion().getBusinessType());
        jsonObject.put("businessName", (Object)llmRequest.getAiChatPojo().getQuestion().getBusinessName());
        jsonObject.put("businessNumber", (Object)llmRequest.getAiChatPojo().getQuestion().getBusinessNumber());
        jsonObject.put("businessId", (Object)llmRequest.getAiChatPojo().getQuestion().getBusinessId());
        jsonObject.put("createBy", (Object)SysUtil.getLoginUser().getSubAccount());
        jsonObject.put("createById", (Object)SysUtil.getLoginUser().getId());
        jsonObject.put("createTime", (Object)new Date());
        jsonObject.put("type", (Object)"head");
        ((StreamBridge)SpringContextUtils.getBean(StreamBridge.class)).send("agentInputLog-out-0", (Object)MessageBuilder.withPayload((Object)JSON.toJSONString((Object)jsonObject)).setHeader("KEYS", (Object)IdWorker.getIdStr()).build());
    }

    public static void sendItem(String headId, String elsAccount, String flowType, String flowTypeName, Integer flowTypeSort, String flowData, String flowErrorLog) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("headId", (Object)headId);
        jsonObject.put("elsAccount", (Object)elsAccount);
        jsonObject.put("flowType", (Object)flowType);
        jsonObject.put("flowTypeName", (Object)flowTypeName);
        jsonObject.put("flowTypeSort", (Object)flowTypeSort);
        jsonObject.put("flowData", (Object)flowData);
        jsonObject.put("flowErrorLog", (Object)flowErrorLog);
        jsonObject.put("logTime", (Object)new Date());
        jsonObject.put("createBy", (Object)SysUtil.getLoginUser().getSubAccount());
        jsonObject.put("createById", (Object)SysUtil.getLoginUser().getId());
        jsonObject.put("createTime", (Object)new Date());
        jsonObject.put("type", (Object)"item");
        ((StreamBridge)SpringContextUtils.getBean(StreamBridge.class)).send("agentInputLog-out-0", (Object)MessageBuilder.withPayload((Object)JSON.toJSONString((Object)jsonObject)).setHeader("KEYS", (Object)IdWorker.getIdStr()).build());
    }
}

