/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ai.entity.AiAgentAppConfigItem;
import com.els.modules.ai.entity.AiAgentConfigHead;
import com.els.modules.ai.entity.AiAgentDataCleanConfigItem;
import com.els.modules.ai.entity.AiAgentDataCollectConfigItem;
import com.els.modules.ai.entity.AiAgentResultConfigItem;
import com.els.modules.ai.mapper.AiAgentConfigHeadMapper;
import com.els.modules.ai.service.AiAgentAppConfigItemService;
import com.els.modules.ai.service.AiAgentConfigHeadService;
import com.els.modules.ai.service.AiAgentDataCleanConfigItemService;
import com.els.modules.ai.service.AiAgentDataCollectConfigItemService;
import com.els.modules.ai.service.AiAgentResultConfigItemService;
import com.els.modules.ai.vo.AiAgentConfigHeadVO;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class AiAgentConfigHeadServiceImpl
extends BaseServiceImpl<AiAgentConfigHeadMapper, AiAgentConfigHead>
implements AiAgentConfigHeadService {
    @Resource
    private AiAgentDataCollectConfigItemService aiAgentDataCollectConfigItemService;
    @Resource
    private AiAgentDataCleanConfigItemService aiAgentDataCleanConfigItemService;
    @Resource
    private AiAgentAppConfigItemService aiAgentAppConfigItemService;
    @Resource
    private AiAgentResultConfigItemService aiAgentResultConfigItemService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(AiAgentConfigHead aiAgentConfigHead, List<AiAgentDataCollectConfigItem> aiAgentDataCollectConfigItemList, List<AiAgentDataCleanConfigItem> aiAgentDataCleanConfigItemList, List<AiAgentAppConfigItem> aiAgentAppConfigItemList, List<AiAgentResultConfigItem> aiAgentResultConfigItemList) {
        ((AiAgentConfigHeadMapper)this.baseMapper).insert((Object)aiAgentConfigHead);
        super.setHeadDefaultValue((BaseEntity)aiAgentConfigHead);
        this.insertData(aiAgentConfigHead, aiAgentDataCollectConfigItemList, aiAgentDataCleanConfigItemList, aiAgentAppConfigItemList, aiAgentResultConfigItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(AiAgentConfigHead aiAgentConfigHead, List<AiAgentDataCollectConfigItem> aiAgentDataCollectConfigItemList, List<AiAgentDataCleanConfigItem> aiAgentDataCleanConfigItemList, List<AiAgentAppConfigItem> aiAgentAppConfigItemList, List<AiAgentResultConfigItem> aiAgentResultConfigItemList) {
        int count = ((AiAgentConfigHeadMapper)this.baseMapper).updateById((Object)aiAgentConfigHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.aiAgentDataCollectConfigItemService.deleteByMainId(aiAgentConfigHead.getId());
        this.aiAgentDataCleanConfigItemService.deleteByMainId(aiAgentConfigHead.getId());
        this.aiAgentAppConfigItemService.deleteByMainId(aiAgentConfigHead.getId());
        this.aiAgentResultConfigItemService.deleteByMainId(aiAgentConfigHead.getId());
        this.insertData(aiAgentConfigHead, aiAgentDataCollectConfigItemList, aiAgentDataCleanConfigItemList, aiAgentAppConfigItemList, aiAgentResultConfigItemList);
    }

    private void insertData(AiAgentConfigHead aiAgentConfigHead, List<AiAgentDataCollectConfigItem> aiAgentDataCollectConfigItemList, List<AiAgentDataCleanConfigItem> aiAgentDataCleanConfigItemList, List<AiAgentAppConfigItem> aiAgentAppConfigItemList, List<AiAgentResultConfigItem> aiAgentResultConfigItemList) {
        int sort;
        if (!CollectionUtils.isEmpty(aiAgentDataCollectConfigItemList)) {
            sort = 1;
            for (AiAgentDataCollectConfigItem aiAgentDataCollectConfigItem : aiAgentDataCollectConfigItemList) {
                aiAgentDataCollectConfigItem.setHeadId(aiAgentConfigHead.getId());
                aiAgentDataCollectConfigItem.setOrderSort(sort++);
                SysUtil.setSysParam((BaseEntity)aiAgentDataCollectConfigItem, (BaseEntity)aiAgentConfigHead);
            }
            this.aiAgentDataCollectConfigItemService.saveBatch(aiAgentDataCollectConfigItemList, 2000);
        }
        if (!CollectionUtils.isEmpty(aiAgentDataCleanConfigItemList)) {
            sort = 1;
            for (AiAgentDataCleanConfigItem aiAgentDataCleanConfigItem : aiAgentDataCleanConfigItemList) {
                aiAgentDataCleanConfigItem.setHeadId(aiAgentConfigHead.getId());
                aiAgentDataCleanConfigItem.setOrderSort(sort++);
                SysUtil.setSysParam((BaseEntity)aiAgentDataCleanConfigItem, (BaseEntity)aiAgentConfigHead);
            }
            this.aiAgentDataCleanConfigItemService.saveBatch(aiAgentDataCleanConfigItemList, 2000);
        }
        if (!CollectionUtils.isEmpty(aiAgentAppConfigItemList)) {
            sort = 1;
            for (AiAgentAppConfigItem aiAgentAppConfigItem : aiAgentAppConfigItemList) {
                aiAgentAppConfigItem.setHeadId(aiAgentConfigHead.getId());
                aiAgentAppConfigItem.setOrderSort(sort++);
                SysUtil.setSysParam((BaseEntity)aiAgentAppConfigItem, (BaseEntity)aiAgentConfigHead);
            }
            this.aiAgentAppConfigItemService.saveBatch(aiAgentAppConfigItemList, 2000);
        }
        if (!CollectionUtils.isEmpty(aiAgentResultConfigItemList)) {
            sort = 1;
            for (AiAgentResultConfigItem aiAgentResultConfigItem : aiAgentResultConfigItemList) {
                aiAgentResultConfigItem.setHeadId(aiAgentConfigHead.getId());
                aiAgentResultConfigItem.setOrderSort(sort++);
                SysUtil.setSysParam((BaseEntity)aiAgentResultConfigItem, (BaseEntity)aiAgentConfigHead);
            }
            this.aiAgentResultConfigItemService.saveBatch(aiAgentResultConfigItemList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.aiAgentDataCollectConfigItemService.deleteByMainId(id);
        this.aiAgentDataCleanConfigItemService.deleteByMainId(id);
        this.aiAgentAppConfigItemService.deleteByMainId(id);
        this.aiAgentResultConfigItemService.deleteByMainId(id);
        ((AiAgentConfigHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public AiAgentConfigHeadVO getByAgentCode(String agentCode) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(AiAgentConfigHead::getAgentCode, (Object)agentCode)).eq(AiAgentConfigHead::getEnable, (Object)"1")).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).last("limit 1");
        AiAgentConfigHead aiAgentConfigHead = (AiAgentConfigHead)((Object)((AiAgentConfigHeadMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        if (null == aiAgentConfigHead) {
            wrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(AiAgentConfigHead::getAgentCode, (Object)agentCode)).eq(AiAgentConfigHead::getEnable, (Object)"1")).eq(BaseEntity::getElsAccount, (Object)"100000")).last("limit 1");
            aiAgentConfigHead = (AiAgentConfigHead)((Object)((AiAgentConfigHeadMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        }
        if (null == aiAgentConfigHead) {
            throw new ELSBootException("Agent\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        AiAgentConfigHeadVO aiAgentConfigHeadVO = new AiAgentConfigHeadVO();
        BeanUtils.copyProperties((Object)((Object)aiAgentConfigHead), (Object)((Object)aiAgentConfigHeadVO));
        List<AiAgentDataCollectConfigItem> aiAgentDataCollectConfigItemList = this.aiAgentDataCollectConfigItemService.selectByMainId(aiAgentConfigHead.getId());
        aiAgentConfigHeadVO.setAiAgentDataCollectConfigItemList(aiAgentDataCollectConfigItemList);
        List<AiAgentDataCleanConfigItem> aiAgentDataCleanConfigItemList = this.aiAgentDataCleanConfigItemService.selectByMainId(aiAgentConfigHead.getId());
        aiAgentConfigHeadVO.setAiAgentDataCleanConfigItemList(aiAgentDataCleanConfigItemList);
        List<AiAgentAppConfigItem> aiAgentAppConfigItemList = this.aiAgentAppConfigItemService.selectByMainId(aiAgentConfigHead.getId());
        aiAgentConfigHeadVO.setAiAgentAppConfigItemList(aiAgentAppConfigItemList);
        List<AiAgentResultConfigItem> aiAgentResultConfigItemList = this.aiAgentResultConfigItemService.selectByMainId(aiAgentConfigHead.getId());
        aiAgentConfigHeadVO.setAiAgentResultConfigItemList(aiAgentResultConfigItemList);
        return aiAgentConfigHeadVO;
    }
}

