/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SysUtil;
import com.els.modules.ai.core.modelStrategy.AiLogicRunStrategy;
import com.els.modules.ai.core.util.AiBeanFactory;
import com.els.modules.ai.entity.AiChatResultLog;
import com.els.modules.ai.pojo.AiChatAppPojo;
import com.els.modules.ai.pojo.AiChatExamplarPojo;
import com.els.modules.ai.pojo.AiChatModelConfigPojo;
import com.els.modules.ai.pojo.AiChatPojo;
import com.els.modules.ai.pojo.LlmRequestPojo;
import com.els.modules.ai.pojo.LlmResponsePojo;
import com.els.modules.ai.pojo.QuestionInfoPojo;
import com.els.modules.ai.service.AiChatAppService;
import com.els.modules.ai.service.AiChatExamplarService;
import com.els.modules.ai.service.AiChatModelConfigService;
import com.els.modules.ai.service.AiChatResultLogService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AiRequestService {
    @Resource
    private AiChatAppService aiChatAppService;
    @Resource
    private AiChatExamplarService aiChatExamplarService;
    @Resource
    private AiChatResultLogService aiChatResultLogService;
    @Resource
    private AiChatModelConfigService aiChatModelConfigService;

    @Transactional(rollbackFor={Exception.class})
    public LlmResponsePojo runChat(LlmRequestPojo llmRequest) {
        AiChatPojo chatDto = llmRequest.getAiChatPojo();
        if (null == chatDto) {
            throw new ELSBootException("\u8c03\u7528\u7684APP\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        AiChatAppPojo chatAppConfig = this.aiChatAppService.loadAiChatAppByCode(chatDto.getAppCode(), SysUtil.getLoginUser().getElsAccount());
        chatDto.setLanguage("zh");
        chatDto.setCurrentDate(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        QuestionInfoPojo questionInfo = chatDto.getQuestion();
        if (CharSequenceUtil.isEmpty((CharSequence)questionInfo.getQuestion())) {
            questionInfo.setQuestion(chatAppConfig.getQuestion());
        }
        List<AiChatExamplarPojo> chatExamplers = this.aiChatExamplarService.loadExamplersByCode(chatDto.getAppCode(), SysUtil.getLoginUser().getElsAccount());
        llmRequest.setAiChatPojo(chatDto);
        llmRequest.setAiChatAppPojo(chatAppConfig);
        llmRequest.setChatExamplers(chatExamplers);
        AiChatModelConfigPojo aiChatModelConfigDto = this.aiChatModelConfigService.loadModelConfigByProvider(chatAppConfig.getModelProvider(), chatAppConfig.getModelName(), SysUtil.getLoginUser().getElsAccount());
        chatAppConfig.setAiChatModelConfigPojo(aiChatModelConfigDto);
        AiLogicRunStrategy runStrategy = AiBeanFactory.getAiLogicRunStrategy(chatAppConfig.getModelRunStrategy());
        LlmResponsePojo result = runStrategy.generate(llmRequest);
        result.setQuestion(questionInfo.getQuestion());
        AiChatResultLog log = new AiChatResultLog();
        log.setElsAccount(SysUtil.getLoginUser().getElsAccount());
        log.setBusinessId(questionInfo.getBusinessId());
        log.setBusinessNumber(questionInfo.getBusinessNumber());
        log.setBusinessType(questionInfo.getBusinessType());
        log.setBusinessName(questionInfo.getBusinessName());
        log.setQuestionInput(result.getQuestionInput());
        log.setQuestionResult(result.getResultText());
        log.setAppCode(chatDto.getAppCode());
        this.aiChatResultLogService.add(log);
        return result;
    }
}

