/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.modelStrategy;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.ai.core.AiChatExtractor;
import com.els.modules.ai.core.AiQuestion;
import com.els.modules.ai.core.helper.AiChatResponseHelper;
import com.els.modules.ai.core.modelStrategy.AiLogicRunStrategy;
import com.els.modules.ai.core.util.AiBeanFactory;
import com.els.modules.ai.core.util.AiUtil;
import com.els.modules.ai.pojo.AiChatAppPojo;
import com.els.modules.ai.pojo.AiChatExamplarPojo;
import com.els.modules.ai.pojo.AiChatPojo;
import com.els.modules.ai.pojo.LlmRequestPojo;
import com.els.modules.ai.pojo.LlmResponsePojo;
import com.els.modules.ai.pojo.QuestionInfoPojo;
import com.google.common.collect.Lists;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.service.AiServices;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class SimpleAiLogicRunStrategy
extends AiLogicRunStrategy
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SimpleAiLogicRunStrategy.class);
    public static final String INSTRUCTION = "#\u89d2\u8272: \u8bf7\u4f5c\u4e3a\u667a\u80fd\u6bd4\u4ef7\u4e13\u5bb6\uff0c\u6309\u4ee5\u4e0b\u6b65\u9aa4\u5904\u7406\u6570\u636e\u5e76\u4ee5MD\u6587\u672c\u683c\u5f0f\u8f93\u51fa\u7ed3\u8bba\u3002\n1.\u6536\u96c6\u6211\u63d0\u4f9b\u7684(\u5f53\u524d\u62a5\u4ef7\u6570\u636e)questionSchema\u548c\u5386\u53f2\u62a5\u4ef7\u6570\u636e(historyPriceSchema)\u6570\u636e\u96c6\u3002\n2.\u8fdb\u884c\u4ef7\u683c\u8d8b\u52bf\u5206\u6790\uff08\u5305\u62ec\u540c\u6bd4/\u73af\u6bd4/\u7b49..\uff09\u3002\n3.\u5efa\u7acb\u591a\u7ef4\u6bd4\u4ef7\u6a21\u578b\uff08\u6700\u4f4e\u4ef7/\u5e73\u5747\u4ef7/\u8fd1\u671f\u6ce2\u52a8/\u7b49..\uff09\u3002\n4.\u751f\u6210\u7ed3\u6784\u5316\u6bd4\u4ef7\u62a5\u544a\uff08\u542b\u4ef7\u683c\u4f18\u52bf\u5224\u65ad\u548c\u8d2d\u4e70\u5efa\u8bae\uff09\u3002\n5.\u8bf7\u7528\u5206\u70b9\u65b9\u5f0f\u8f93\u51fa\u6838\u5fc3\u7ed3\u8bba\uff0c\u5e76\u6807\u6ce8\u5173\u952e\u6570\u636e\u5bf9\u6bd4\u3002\n#Exemplars: {{exemplar}}\n#Query:\nQuestion:{{question}} \nquestionSchema:{{questionSchema}} \nSideInfo:{{information}} ";

    @Override
    String modelRunStrategy() {
        return "simpleAiLogicRunStrategy";
    }

    @Override
    public LlmResponsePojo generate(LlmRequestPojo llmRequest) {
        LlmResponsePojo llmResponse = new LlmResponsePojo();
        AiChatPojo chatChatConfig = llmRequest.getAiChatPojo();
        AiChatAppPojo chatAppConfig = llmRequest.getAiChatAppPojo();
        QuestionInfoPojo question = chatChatConfig.getQuestion();
        String questionText = CharSequenceUtil.isEmpty((CharSequence)question.getQuestion()) ? chatAppConfig.getQuestion() : question.getQuestion();
        llmResponse.setQuestion(questionText);
        List<List<AiChatExamplarPojo>> exemplarsList = this.promptHelper.getFewShotExemplars(llmRequest);
        AiChatAppPojo chatApp = llmRequest.getAiChatAppPojo();
        if (StringUtils.isEmpty((CharSequence)chatApp.getPromptTemplate())) {
            chatApp.setPromptTemplate(INSTRUCTION);
        }
        StringBuilder promptTemplate = new StringBuilder(chatApp.getPromptTemplate());
        StringBuilder appTemplate = new StringBuilder("");
        for (String schemaKey : question.getQuestionSchemaMap().keySet()) {
            appTemplate.append("\n").append(schemaKey).append(":\n{{").append(schemaKey).append("}}");
        }
        String lastTemplate = "";
        lastTemplate = chatApp.getPromptTemplate().contains("_SYS_INPUT_REPLACE_") ? chatApp.getPromptTemplate().replace("_SYS_INPUT_REPLACE_", appTemplate.toString()) : promptTemplate.append(appTemplate.toString()).toString();
        chatApp.setPromptTemplate(lastTemplate);
        ChatLanguageModel chatLanguageModel = this.getChatLanguageModel(chatApp.getAiChatModelConfigPojo());
        AiChatExtractor extractor = (AiChatExtractor)AiServices.create(AiChatExtractor.class, (ChatLanguageModel)chatLanguageModel);
        HashMap<Prompt, List<AiChatExamplarPojo>> prompt2Exemplar = new HashMap<Prompt, List<AiChatExamplarPojo>>();
        for (List<AiChatExamplarPojo> exemplars : exemplarsList) {
            llmRequest.setChatExamplers(exemplars);
            Prompt prompt2 = this.generatePrompt(llmRequest, llmResponse, chatApp);
            prompt2Exemplar.put(prompt2, exemplars);
        }
        ConcurrentHashMap output2Prompt = new ConcurrentHashMap();
        prompt2Exemplar.keySet().parallelStream().forEach(prompt -> {
            llmResponse.setQuestionInput(prompt.toUserMessage().singleText());
            AiQuestion answer = extractor.generateResult(prompt.toUserMessage().singleText());
            output2Prompt.put(answer.getResultText(), prompt);
        });
        AiChatResponseHelper responseHelper = AiBeanFactory.getAiChatResponseHelper(chatAppConfig.getModelRunResponseHelper());
        Pair<String, Map<String, Double>> sqlMapPair = responseHelper.selfConsistencyVote(Lists.newArrayList(output2Prompt.keySet()));
        llmResponse.setResultText((String)sqlMapPair.getLeft());
        return llmResponse;
    }

    protected Prompt generatePrompt(LlmRequestPojo llmRequest, LlmResponsePojo llmResponse, AiChatAppPojo chatApp) {
        StringBuilder exemplars = new StringBuilder();
        String inputTextType = llmRequest.getAiChatAppPojo().getInputTextType();
        for (AiChatExamplarPojo exemplar : llmRequest.getChatExamplers()) {
            StringBuilder questionSchema = new StringBuilder("");
            if (CharSequenceUtil.isNotEmpty((CharSequence)exemplar.getQuestionSchema())) {
                JSONObject questionSchemaObj = JSON.parseObject((String)exemplar.getQuestionSchema());
                for (String questionSchemaKey : questionSchemaObj.keySet()) {
                    questionSchema.append(String.format(questionSchemaKey + ":%s", AiUtil.jsonTextFormat(JSON.toJSONString((Object)questionSchemaObj.get((Object)questionSchemaKey)), inputTextType) + ","));
                }
            }
            String exemplarStr = String.format("\nQuestion:%s," + questionSchema.toString() + "SideInfo:%s,QuestionResult:%s", exemplar.getQuestion(), exemplar.getSideInfo(), exemplar.getQuestionResult());
            exemplars.append(exemplarStr);
        }
        String questionSchema = this.promptHelper.buildSchemaStr(llmRequest);
        String sideInformation = this.promptHelper.buildSideInformation(llmRequest);
        llmResponse.setQuestionSchema(questionSchema);
        llmResponse.setSideInfo(sideInformation);
        AiChatAppPojo chatAppConfig = llmRequest.getAiChatAppPojo();
        QuestionInfoPojo question = llmRequest.getAiChatPojo().getQuestion();
        String questionText = CharSequenceUtil.isEmpty((CharSequence)question.getQuestion()) ? chatAppConfig.getQuestion() : question.getQuestion();
        HashMap<String, CharSequence> variable = new HashMap<String, CharSequence>();
        variable.put("exemplar", exemplars);
        variable.put("question", questionText);
        variable.put("questionSchema", questionSchema);
        variable.put("information", sideInformation);
        if (CollectionUtil.isNotEmpty((Map)question.getQuestionSchemaMap())) {
            question.getQuestionSchemaMap().forEach((key, val) -> {
                if (!variable.containsKey(key)) {
                    variable.put((String)key, AiUtil.jsonTextFormat(val, inputTextType));
                }
            });
        }
        String promptTemplate = chatApp.getPromptTemplate();
        return PromptTemplate.from((String)promptTemplate).apply(variable);
    }
}

