/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.agent.collect;

import com.alibaba.fastjson.JSONObject;
import com.els.modules.ai.core.agent.AgentStrategyFactory;
import com.els.modules.ai.core.agent.collect.CollectStrategy;
import com.els.modules.ai.entity.AiAgentDataCollectConfigItem;
import com.els.modules.ai.enums.AgentStepType;
import com.els.modules.ai.listener.AgentMqUtil;
import com.els.modules.ai.pojo.AgentLlmRequestPojo;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractCollectStrategy
implements CollectStrategy,
InitializingBean {
    public void afterPropertiesSet() throws Exception {
        AgentStrategyFactory.register(this.type(), this);
    }

    public abstract String doExecute(AgentLlmRequestPojo var1, AiAgentDataCollectConfigItem var2, JSONObject var3);

    @Override
    public String execute(AgentLlmRequestPojo llmRequest, AiAgentDataCollectConfigItem config, JSONObject input) {
        try {
            String result = this.doExecute(llmRequest, config, input);
            AgentMqUtil.sendItem(llmRequest.getLogHeadId(), llmRequest.getElsAccount(), AgentStepType.COLLECT_DATA.getType(), config.getName(), config.getOrderSort(), result, "");
            return result;
        }
        catch (Exception e) {
            AgentMqUtil.sendItem(llmRequest.getLogHeadId(), llmRequest.getElsAccount(), AgentStepType.COLLECT_DATA.getType(), config.getName(), config.getOrderSort(), null == input.getString("responseBody") ? "" : input.getString("responseBody"), e.getMessage());
            throw e;
        }
    }
}

