/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.ai.core.helper.SimpleResponseHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SimpleFileResponseHelper
extends SimpleResponseHelper {
    private static final Logger log = LoggerFactory.getLogger(SimpleFileResponseHelper.class);

    @Override
    public String responseHelperType() {
        return "simpleFileResponseHelper";
    }

    @Override
    public Pair<String, Map<String, Double>> selfConsistencyVote(List<String> outputList) {
        HashMap<String, Integer> inputCounts = new HashMap<String, Integer>();
        for (String input : outputList) {
            inputCounts.put(input, inputCounts.getOrDefault(input, 0) + 1);
        }
        String inputMax = null;
        int maxCount = 0;
        int inputSize = outputList.size();
        HashMap<String, Double> votePercentage = new HashMap<String, Double>();
        for (Map.Entry entry : inputCounts.entrySet()) {
            String input = (String)entry.getKey();
            JSONObject jsonObject = JSON.parseObject((String)input);
            input = jsonObject.getJSONArray("choices").getJSONObject(0).getJSONObject("message").getString("content");
            input = input.replace("```json", "").replace("```", "");
            int count = (Integer)entry.getValue();
            if (count > maxCount) {
                inputMax = input;
                maxCount = count;
            }
            double percentage = (double)count / (double)inputSize;
            votePercentage.put(input, percentage);
        }
        return Pair.of(inputMax, votePercentage);
    }
}

