/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.listener;

import cn.hutool.core.util.BooleanUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.ai.entity.AiAgentChatFlowLogHead;
import com.els.modules.ai.entity.AiAgentChatFlowLogItem;
import com.els.modules.ai.service.AiAgentChatFlowLogHeadService;
import com.els.modules.ai.service.AiAgentChatFlowLogItemService;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;

@Service
public class AiAgentLogConsumer {
    private static final Logger log = LoggerFactory.getLogger(AiAgentLogConsumer.class);
    @Resource
    private AiAgentChatFlowLogHeadService aiAgentChatFlowLogHeadService;
    @Resource
    private AiAgentChatFlowLogItemService aiAgentChatFlowLogItemService;

    @Bean(value={"agentInputLog"})
    public Consumer<Message<String>> receive() {
        return message -> {
            String msgBody = (String)message.getPayload();
            try {
                JSONObject log = JSONObject.parseObject((String)msgBody);
                String type = log.getString("type");
                if ("head".equals(type)) {
                    Boolean update = log.getBoolean("update");
                    if (BooleanUtil.isTrue((Boolean)update)) {
                        AiAgentChatFlowLogHead aiAgentChatFlowLogHead = new AiAgentChatFlowLogHead();
                        aiAgentChatFlowLogHead.setId(log.getString("id"));
                        aiAgentChatFlowLogHead.setQuestionInput(log.getString("questionInput"));
                        aiAgentChatFlowLogHead.setQuestionResult(log.getString("questionResult"));
                        this.aiAgentChatFlowLogHeadService.updateById((Object)aiAgentChatFlowLogHead);
                    } else {
                        AiAgentChatFlowLogHead aiAgentChatFlowLogHead = (AiAgentChatFlowLogHead)((Object)((Object)log.toJavaObject(AiAgentChatFlowLogHead.class)));
                        this.aiAgentChatFlowLogHeadService.save((Object)aiAgentChatFlowLogHead);
                    }
                } else {
                    AiAgentChatFlowLogItem aiAgentChatFlowLogItem = (AiAgentChatFlowLogItem)((Object)((Object)log.toJavaObject(AiAgentChatFlowLogItem.class)));
                    this.aiAgentChatFlowLogItemService.save((Object)aiAgentChatFlowLogItem);
                }
            }
            catch (Exception e) {
                log.error("save agent log failed:", (Throwable)e);
            }
        };
    }
}

