/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.custom.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.service.SaleAttachmentService;
import com.els.modules.attachment.vo.AttachmentSendVO;
import com.els.modules.custom.entity.PurchaseCustomFormHead;
import com.els.modules.custom.entity.SaleCustomFormHead;
import com.els.modules.custom.mapper.SaleCustomFormHeadMapper;
import com.els.modules.custom.service.PurchaseCustomFormHeadService;
import com.els.modules.custom.service.SaleCustomFormAttachmentService;
import com.els.modules.custom.service.SaleCustomFormExtendService;
import com.els.modules.custom.service.SaleCustomFormHeadService;
import com.els.modules.custom.service.SaleCustomFormItemExtendService;
import java.io.Serializable;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleCustomFormHeadServiceImpl
extends BaseServiceImpl<SaleCustomFormHeadMapper, SaleCustomFormHead>
implements SaleCustomFormHeadService {
    @Resource
    private SaleCustomFormExtendService saleCustomFormExtendService;
    @Resource
    private SaleCustomFormItemExtendService saleCustomFormItemExtendService;
    @Resource
    private SaleCustomFormAttachmentService saleCustomFormAttachmentService;
    @Resource
    private SaleAttachmentService saleAttachmentService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public SaleCustomFormHead saveMain(JSONObject headObj) {
        SaleCustomFormHead formHead = (SaleCustomFormHead)((Object)JSON.parseObject((String)headObj.toJSONString(), SaleCustomFormHead.class));
        formHead.setId(IdWorker.getIdStr());
        this.save((Object)formHead);
        headObj.put("id", (Object)formHead.getId());
        this.saleCustomFormExtendService.save(headObj);
        this.saleCustomFormItemExtendService.save(headObj);
        this.saleCustomFormAttachmentService.saveAttachment(headObj);
        return formHead;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(JSONObject headObj) {
        SaleCustomFormHead formHead = (SaleCustomFormHead)((Object)JSON.parseObject((String)headObj.toJSONString(), SaleCustomFormHead.class));
        this.updateById((Object)formHead);
        this.saleCustomFormExtendService.deleteByMainId(formHead.getId(), formHead.getBusinessType());
        this.saleCustomFormItemExtendService.deleteByMainId(formHead.getId(), formHead.getBusinessType());
        this.saleCustomFormAttachmentService.deleteByMainId(formHead.getId(), formHead.getBusinessType());
        this.saleCustomFormExtendService.save(headObj);
        this.saleCustomFormItemExtendService.save(headObj);
        this.saleCustomFormAttachmentService.saveAttachment(headObj);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateHead(JSONObject headObj) {
        SaleCustomFormHead formHead = (SaleCustomFormHead)((Object)JSON.parseObject((String)headObj.toJSONString(), SaleCustomFormHead.class));
        this.updateById((Object)formHead);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id, String businessType) {
        this.saleCustomFormExtendService.deleteByMainId(id, businessType);
        this.saleCustomFormItemExtendService.deleteByMainId(id, businessType);
        this.saleCustomFormAttachmentService.deleteByMainId(id, businessType);
        ((SaleCustomFormHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void recevie(JSONObject headObj, PurchaseCustomFormHead purchaseFormHead) {
        if (StrUtil.isBlank((CharSequence)purchaseFormHead.getToElsAccount())) {
            throw new ELSBootException("\u4f9b\u5e94\u5546ELS\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SaleCustomFormHead saleformHead = new SaleCustomFormHead();
        BeanUtils.copyProperties((Object)((Object)purchaseFormHead), (Object)((Object)saleformHead));
        saleformHead.setId(purchaseFormHead.getRelationId());
        saleformHead.setRelationId(purchaseFormHead.getId());
        saleformHead.setElsAccount(purchaseFormHead.getToElsAccount());
        saleformHead.setToElsAccount(purchaseFormHead.getElsAccount());
        saleformHead.setPurchaseName(SysUtil.getLoginUser().getEnterpriseName());
        SaleCustomFormHead dbHead = (SaleCustomFormHead)((Object)((SaleCustomFormHeadMapper)this.baseMapper).selectById((Serializable)((Object)saleformHead.getId())));
        if (dbHead == null) {
            this.save((Object)saleformHead);
        } else {
            this.updateById((Object)saleformHead);
            this.saleCustomFormExtendService.deleteByMainId(saleformHead.getId(), saleformHead.getBusinessType());
            this.saleCustomFormItemExtendService.deleteByMainId(saleformHead.getId(), saleformHead.getBusinessType());
            this.saleCustomFormAttachmentService.deleteByMainId(saleformHead.getId(), saleformHead.getBusinessType());
        }
        headObj.put("id", (Object)saleformHead.getId());
        headObj.put("elsAccount", (Object)saleformHead.getElsAccount());
        this.saleCustomFormExtendService.save(headObj);
        this.saleCustomFormItemExtendService.save(headObj);
        this.saleCustomFormAttachmentService.saveAttachment(headObj);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void send(JSONObject headObj) {
        String id;
        SaleCustomFormHead formHead = (SaleCustomFormHead)((Object)JSON.parseObject((String)headObj.toJSONString(), SaleCustomFormHead.class));
        if (StrUtil.isBlank((CharSequence)formHead.getRelationId())) {
            formHead.setRelationId(IdWorker.getIdStr());
        }
        if (StrUtil.isBlank((CharSequence)(id = formHead.getId()))) {
            formHead.setId(IdWorker.getIdStr());
            this.save((Object)formHead);
            headObj.put("id", (Object)formHead.getId());
            headObj.put("elsAccount", (Object)TenantContext.getTenant());
        } else {
            this.updateById((Object)formHead);
            this.saleCustomFormExtendService.deleteByMainId(formHead.getId(), formHead.getBusinessType());
            this.saleCustomFormItemExtendService.deleteByMainId(formHead.getId(), formHead.getBusinessType());
            this.saleCustomFormAttachmentService.deleteByMainId(formHead.getId(), formHead.getBusinessType());
        }
        this.saleCustomFormExtendService.save(headObj);
        this.saleCustomFormItemExtendService.save(headObj);
        this.saleCustomFormAttachmentService.saveAttachment(headObj);
        ((PurchaseCustomFormHeadService)SpringContextUtils.getBean(PurchaseCustomFormHeadService.class)).recevie(headObj, formHead);
        AttachmentSendVO sendVO = new AttachmentSendVO();
        sendVO.setElsAccount(TenantContext.getTenant());
        HashMap<String, String> toSend = new HashMap<String, String>();
        toSend.put(formHead.getRelationId(), formHead.getToElsAccount());
        sendVO.setToSend(toSend);
        sendVO.setHeadId(formHead.getId());
        this.saleAttachmentService.sendFile(sendVO);
    }

    @Override
    public void recevieHead(PurchaseCustomFormHead purchaseFormHead) {
        if (StrUtil.isBlank((CharSequence)purchaseFormHead.getToElsAccount())) {
            throw new ELSBootException("\u4f9b\u5e94\u5546ELS\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SaleCustomFormHead saleformHead = new SaleCustomFormHead();
        BeanUtils.copyProperties((Object)((Object)purchaseFormHead), (Object)((Object)saleformHead));
        saleformHead.setId(purchaseFormHead.getRelationId());
        saleformHead.setRelationId(purchaseFormHead.getId());
        saleformHead.setElsAccount(purchaseFormHead.getToElsAccount());
        saleformHead.setToElsAccount(purchaseFormHead.getElsAccount());
        saleformHead.setPurchaseName(SysUtil.getLoginUser().getEnterpriseName());
        SaleCustomFormHead dbHead = (SaleCustomFormHead)((Object)((SaleCustomFormHeadMapper)this.baseMapper).selectById((Serializable)((Object)saleformHead.getId())));
        if (dbHead == null) {
            this.save((Object)saleformHead);
        } else {
            this.updateById((Object)saleformHead);
        }
    }
}

