/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ainpl.core;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.ai.pojo.AiOrderCreationCheckPojo;
import com.els.modules.ai.pojo.LlmResponsePojo;
import com.els.modules.ainpl.entity.AiOrderCreationDefaultCondition;
import com.els.modules.ainpl.entity.AiOrderCreationDialogAiSession;
import com.els.modules.ainpl.entity.AiOrderCreationDialogSession;
import com.els.modules.ainpl.entity.AiOrderCreationDialogUserSession;
import com.els.modules.ainpl.entity.AiOrderCreationModelExtendItem;
import com.els.modules.ainpl.entity.AiOrderCreationModelHead;
import com.els.modules.ainpl.entity.AiOrderCreationModelItem;
import com.els.modules.ainpl.enums.AiOrderCreationSessionStatus;
import com.els.modules.ainpl.service.AiOrderCreationDefaultConditionService;
import com.els.modules.ainpl.service.AiOrderCreationDialogAiSessionService;
import com.els.modules.ainpl.service.AiOrderCreationDialogSessionService;
import com.els.modules.ainpl.service.AiOrderCreationDialogUserSessionService;
import com.els.modules.ainpl.service.AiOrderCreationModelExtendItemService;
import com.els.modules.ainpl.service.AiOrderCreationModelHeadService;
import com.els.modules.ainpl.service.AiOrderCreationModelItemService;
import com.els.modules.ainpl.vo.AiOrderCreationCurrentSession;
import com.els.modules.ainpl.vo.AiOrderCreationFiledSchemaDTO;
import com.els.modules.ainpl.vo.AiOrderCreationFiledSchemaExtendDTO;
import com.els.modules.ainpl.vo.AiOrderCreationRequestDTO;
import com.els.modules.ainpl.vo.AiOrderCreationUnCompletedSession;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SessionBuilder {
    @Autowired
    private AiOrderCreationDialogAiSessionService aiOrderCreationDialogAiSessionService;
    @Autowired
    private AiOrderCreationDialogUserSessionService aiOrderCreationDialogUserSessionService;
    @Autowired
    private AiOrderCreationDefaultConditionService aiOrderCreationDefaultConditionService;
    @Autowired
    private AiOrderCreationModelHeadService aiOrderCreationModelHeadService;
    @Autowired
    private AiOrderCreationModelItemService aiOrderCreationModelItemService;
    @Autowired
    private AiOrderCreationModelExtendItemService aiOrderCreationModelExtendItemService;
    @Autowired
    private AiOrderCreationDialogSessionService aiOrderCreationDialogSessionService;

    public AiOrderCreationUnCompletedSession findUnCompletedSessionByRequest(AiOrderCreationRequestDTO request) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(AiOrderCreationDialogAiSession::getSessionId, (Object)request.getSessionId())).eq(AiOrderCreationDialogAiSession::getUserId, (Object)request.getUserId())).eq(AiOrderCreationDialogAiSession::getDataModelId, (Object)request.getDataModelId());
        wrapper.orderByDesc(BaseEntity::getId);
        wrapper.last("limit 1");
        AiOrderCreationDialogAiSession session = (AiOrderCreationDialogAiSession)((Object)this.aiOrderCreationDialogAiSessionService.getOne((Wrapper)wrapper));
        if (null == session) {
            return null;
        }
        if (!AiOrderCreationSessionStatus.RUNNING.getCode().equals(session.getStatus())) {
            return null;
        }
        AiOrderCreationUnCompletedSession unCompletedSession = new AiOrderCreationUnCompletedSession();
        unCompletedSession.setUserSessionItemId(session.getUserSessionItemId());
        unCompletedSession.setDataModelId(request.getDataModelId());
        unCompletedSession.setUserId(request.getUserId());
        AiOrderCreationDialogUserSession userSession = (AiOrderCreationDialogUserSession)((Object)this.aiOrderCreationDialogUserSessionService.getById((Serializable)((Object)session.getUserSessionItemId())));
        if (null == userSession) {
            return null;
        }
        unCompletedSession.setQueryText(userSession.getQueryText());
        unCompletedSession.setFinalCondition(session.getFinalCondition());
        unCompletedSession.setQueryResult(session.getQueryResult());
        unCompletedSession.setRawInput(session.getRawInput());
        return unCompletedSession;
    }

    public void buildQuestionSchema(AiOrderCreationCurrentSession currentSession, AiOrderCreationUnCompletedSession unCompletedSession, Map<String, String> questionSchemaMap) {
        String dataModelId;
        AiOrderCreationModelHead modelHead;
        if (null == questionSchemaMap) {
            questionSchemaMap = new HashMap<String, String>();
        }
        if (null == (modelHead = (AiOrderCreationModelHead)((Object)this.aiOrderCreationModelHeadService.getById((Serializable)((Object)(dataModelId = currentSession.getDataModelId())))))) {
            throw new ELSBootException("\u6570\u636e\u6a21\u578b\u4e0d\u5b58\u5728");
        }
        if (!"1".equals(modelHead.getStatus())) {
            throw new ELSBootException("\u6570\u636e\u6a21\u578b\u4e0d\u53ef\u7528");
        }
        currentSession.setBusinessType(modelHead.getBusinessType());
        List<AiOrderCreationModelItem> modelItems = this.aiOrderCreationModelItemService.selectByMainId(dataModelId);
        if (CollectionUtil.isEmpty(modelItems)) {
            throw new ELSBootException("\u6570\u636e\u6a21\u578b\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        List<AiOrderCreationFiledSchemaDTO> schemaList = modelItems.stream().filter(x -> !"1".equals(x.getBringValue())).map(x -> {
            AiOrderCreationFiledSchemaDTO schemaDTO = new AiOrderCreationFiledSchemaDTO();
            schemaDTO.setFieldName(x.getModelFieldName());
            schemaDTO.setFieldCode(x.getModelFieldCode());
            schemaDTO.setFieldAlias((List<String>)(CharSequenceUtil.isEmpty((CharSequence)x.getModelFieldAlias()) ? Lists.newArrayList() : Arrays.stream(x.getModelFieldAlias().split(",")).toList()));
            schemaDTO.setFieldType(x.getModelFieldType());
            schemaDTO.setFieldDictCode(x.getModelFieldDict());
            schemaDTO.setDictFuzzySegmentation(x.getDictFuzzySegmentation());
            schemaDTO.setAssociationSplit(x.getAssociationSplit());
            schemaDTO.setBringValue(x.getBringValue());
            schemaDTO.setAssociationColumn(x.getAssociationColumn());
            return schemaDTO;
        }).collect(Collectors.toList());
        questionSchemaMap.put("questionSchema", JSON.toJSONString(schemaList));
        currentSession.setSchemaList(schemaList);
        List<AiOrderCreationModelExtendItem> modelExtendItems = this.aiOrderCreationModelExtendItemService.selectByMainId(dataModelId);
        List schemaExtendList = modelExtendItems.stream().map(x -> {
            AiOrderCreationFiledSchemaExtendDTO schemaDTO = new AiOrderCreationFiledSchemaExtendDTO();
            schemaDTO.setFieldName(x.getModelFiledConfigName());
            schemaDTO.setFieldCode(x.getModelFiledConfigCode());
            schemaDTO.setFieldDesc(x.getModelFiledConfigDesc());
            schemaDTO.setFieldValue(x.getModelFiledConfigValue());
            return schemaDTO;
        }).collect(Collectors.toList());
        questionSchemaMap.put("questionSchemaSideInfo", JSON.toJSONString(schemaExtendList));
        if (null == unCompletedSession) {
            questionSchemaMap.put("lastQuestion", "");
            questionSchemaMap.put("lastQueryResult", "");
        } else {
            questionSchemaMap.put("lastQuestion", unCompletedSession.getQueryText());
            questionSchemaMap.put("lastQueryResult", unCompletedSession.getFinalCondition());
        }
    }

    public AiOrderCreationCurrentSession buildNewSessionByRequest(AiOrderCreationRequestDTO request, AiOrderCreationUnCompletedSession unCompletedSession) {
        AiOrderCreationModelHead model;
        AiOrderCreationCurrentSession currentSession = new AiOrderCreationCurrentSession();
        String defaultConditionId = request.getDefaultConditionId();
        if (CharSequenceUtil.isNotEmpty((CharSequence)defaultConditionId)) {
            AiOrderCreationDefaultCondition condition = (AiOrderCreationDefaultCondition)((Object)this.aiOrderCreationDefaultConditionService.getById((Serializable)((Object)defaultConditionId)));
            if (null == condition) {
                throw new ELSBootException("\u9884\u8bbe\u6761\u4ef6\u4e0d\u5b58\u5728ID:{}", new String[]{defaultConditionId});
            }
            currentSession.setDefaultConditionId(defaultConditionId);
            currentSession.setDefaultConditionJson(condition.getConditionData());
            currentSession.setConditionStatus(condition.getConditionStatus());
        }
        if (null == (model = (AiOrderCreationModelHead)((Object)this.aiOrderCreationModelHeadService.getById((Serializable)((Object)request.getDataModelId()))))) {
            throw new ELSBootException("\u6570\u636e\u6a21\u578b\u4e0d\u5b58\u5728");
        }
        currentSession.setSessionId(request.getSessionId());
        currentSession.setDataModelId(request.getDataModelId());
        currentSession.setBusinessType(model.getBusinessType());
        currentSession.setBeanImpl(model.getBeanImpl());
        currentSession.setQueryText(request.getQueryText());
        StringBuilder input = new StringBuilder("");
        if (null != unCompletedSession) {
            input.append(unCompletedSession.getRawInput()).append("\n").append(request.getQueryText());
        } else {
            input.append(request.getQueryText());
        }
        currentSession.setRawInput(input.toString());
        currentSession.setUserSessionItemId(IdWorker.getIdStr());
        currentSession.setUserId(SysUtil.getLoginUser().getId());
        return currentSession;
    }

    public void saveUserSession(AiOrderCreationCurrentSession currentSession, AiOrderCreationUnCompletedSession unCompletedSession) {
        AiOrderCreationDialogUserSession userSession = new AiOrderCreationDialogUserSession();
        userSession.setId(currentSession.getUserSessionItemId());
        userSession.setUserId(currentSession.getUserId());
        userSession.setDataModelId(currentSession.getDataModelId());
        userSession.setSessionId(currentSession.getSessionId());
        userSession.setQueryText(currentSession.getQueryText());
        userSession.setDefaultConditionId(currentSession.getDefaultConditionId());
        userSession.setElsAccount(SysUtil.getLoginUser().getElsAccount());
        if (null != unCompletedSession) {
            userSession.setLastQueryText(unCompletedSession.getQueryText());
        } else {
            userSession.setLastQueryText("");
        }
        this.aiOrderCreationDialogUserSessionService.save((Object)userSession);
    }

    public AiOrderCreationDialogAiSession saveAiSession(AiOrderCreationCurrentSession currentSession, AiOrderCreationUnCompletedSession unCompletedSession, AiOrderCreationCheckPojo creationCheckPojo, LlmResponsePojo llmResponsePojo) {
        AiOrderCreationDialogAiSession aiSession = new AiOrderCreationDialogAiSession();
        aiSession.setId(IdWorker.getIdStr());
        aiSession.setUserId(currentSession.getUserId());
        aiSession.setDataModelId(currentSession.getDataModelId());
        aiSession.setUserSessionItemId(currentSession.getUserSessionItemId());
        aiSession.setSessionId(currentSession.getSessionId());
        aiSession.setQueryResult(currentSession.getQueryResult());
        aiSession.setFinalCondition(currentSession.getFinalCondition());
        aiSession.setFinalConditionText(currentSession.getFinalConditionText());
        aiSession.setLastFinalCondition(currentSession.getLastFinalCondition());
        aiSession.setLastFinalConditionText(currentSession.getLastFinalConditionText());
        aiSession.setRawInput(currentSession.getRawInput());
        aiSession.setCheckMessage(creationCheckPojo.getCheckMessage());
        aiSession.setCheckPass(creationCheckPojo.isCheckPass() ? "1" : "0");
        aiSession.setStatus(AiOrderCreationSessionStatus.RUNNING.getCode());
        aiSession.setElsAccount(SysUtil.getLoginUser().getElsAccount());
        this.aiOrderCreationDialogAiSessionService.save((Object)aiSession);
        return aiSession;
    }

    public AiOrderCreationDialogSession getOrSaveOrUpdateSession(AiOrderCreationRequestDTO requestDTO) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getId, (Object)requestDTO.getSessionId())).eq(AiOrderCreationDialogSession::getUserId, (Object)requestDTO.getUserId());
        AiOrderCreationDialogSession session = (AiOrderCreationDialogSession)((Object)this.aiOrderCreationDialogSessionService.getOne((Wrapper)wrapper));
        if (null == session) {
            session = new AiOrderCreationDialogSession();
            session.setUserId(requestDTO.getUserId());
            session.setId(requestDTO.getSessionId());
            session.setSessionName(SessionBuilder.truncateWithEllipsis(requestDTO.getQueryText(), 10));
            this.aiOrderCreationDialogSessionService.save((Object)session);
        } else {
            session.setSessionName(SessionBuilder.truncateWithEllipsis(requestDTO.getQueryText(), 10));
            this.aiOrderCreationDialogSessionService.updateById((Object)session);
        }
        return session;
    }

    public static String truncateWithEllipsis(String original, int maxLength) {
        if (original == null || original.length() <= maxLength) {
            return original;
        }
        return original.substring(0, maxLength) + "...";
    }
}

