/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ai.core.AiRequestService;
import com.els.modules.ai.core.agent.DataAppRunner;
import com.els.modules.ai.core.agent.DataCleanRunner;
import com.els.modules.ai.core.agent.DataCollectRunner;
import com.els.modules.ai.core.agent.DataResultRunner;
import com.els.modules.ai.core.modelStrategy.dync.AiEnhanceBeanHolder;
import com.els.modules.ai.entity.AiAgentAppConfigItem;
import com.els.modules.ai.entity.AiAgentConfigHead;
import com.els.modules.ai.entity.AiAgentDataCleanConfigItem;
import com.els.modules.ai.entity.AiAgentDataCollectConfigItem;
import com.els.modules.ai.entity.AiAgentResultConfigItem;
import com.els.modules.ai.entity.AiChatResultLog;
import com.els.modules.ai.listener.AgentMqUtil;
import com.els.modules.ai.pojo.AgentLlmRequestPojo;
import com.els.modules.ai.pojo.AgnetCommonRequestPojo;
import com.els.modules.ai.pojo.AiChatPojo;
import com.els.modules.ai.pojo.LlmResponsePojo;
import com.els.modules.ai.pojo.QuestionInfoPojo;
import com.els.modules.ai.service.AiAgentAppConfigItemService;
import com.els.modules.ai.service.AiAgentConfigHeadService;
import com.els.modules.ai.service.AiAgentDataCleanConfigItemService;
import com.els.modules.ai.service.AiAgentDataCollectConfigItemService;
import com.els.modules.ai.service.AiAgentResultConfigItemService;
import com.els.modules.ai.service.AiChatResultLogService;
import com.els.modules.ai.vo.AiAgentConfigHeadVO;
import com.els.modules.system.rpc.service.BaseInvokeAiChatRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ai/aiAgentConfigHead"})
@Api(tags={"agent\u57fa\u672c\u4fe1\u606f"})
public class AiAgentConfigHeadController
extends BaseController<AiAgentConfigHead, AiAgentConfigHeadService> {
    private static final Logger log = LoggerFactory.getLogger(AiAgentConfigHeadController.class);
    @Autowired
    private AiAgentConfigHeadService aiAgentConfigHeadService;
    @Autowired
    private AiAgentDataCollectConfigItemService aiAgentDataCollectConfigItemService;
    @Autowired
    private AiAgentDataCleanConfigItemService aiAgentDataCleanConfigItemService;
    @Autowired
    private AiAgentAppConfigItemService aiAgentAppConfigItemService;
    @Autowired
    private AiAgentResultConfigItemService aiAgentResultConfigItemService;
    @Resource
    private AiChatResultLogService aiChatResultLogService;
    @Resource
    private AiRequestService aiRequestService;
    @Autowired
    private BaseInvokeAiChatRpcService baseInvokeAiChatRpcService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String AI_CHAT = "srm:ai_agent_chat:";
    private static final Long LOCK_EXPIRE_TIME = 30000L;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(AiAgentConfigHead aiAgentConfigHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)aiAgentConfigHead), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.aiAgentConfigHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="agent\u57fa\u672c\u4fe1\u606f", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody AiAgentConfigHeadVO aiAgentConfigHeadPage) {
        AiAgentConfigHead aiAgentConfigHead = new AiAgentConfigHead();
        BeanUtils.copyProperties((Object)((Object)aiAgentConfigHeadPage), (Object)((Object)aiAgentConfigHead));
        this.aiAgentConfigHeadService.saveMain(aiAgentConfigHead, aiAgentConfigHeadPage.getAiAgentDataCollectConfigItemList(), aiAgentConfigHeadPage.getAiAgentDataCleanConfigItemList(), aiAgentConfigHeadPage.getAiAgentAppConfigItemList(), aiAgentConfigHeadPage.getAiAgentResultConfigItemList());
        return Result.ok((Object)((Object)aiAgentConfigHead));
    }

    @AutoLog(busModule="agent\u57fa\u672c\u4fe1\u606f", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody AiAgentConfigHeadVO aiAgentConfigHeadPage) {
        AiAgentConfigHead aiAgentConfigHead = new AiAgentConfigHead();
        BeanUtils.copyProperties((Object)((Object)aiAgentConfigHeadPage), (Object)((Object)aiAgentConfigHead));
        this.aiAgentConfigHeadService.updateMain(aiAgentConfigHead, aiAgentConfigHeadPage.getAiAgentDataCollectConfigItemList(), aiAgentConfigHeadPage.getAiAgentDataCleanConfigItemList(), aiAgentConfigHeadPage.getAiAgentAppConfigItemList(), aiAgentConfigHeadPage.getAiAgentResultConfigItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="agent\u57fa\u672c\u4fe1\u606f", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.aiAgentConfigHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        AiAgentConfigHead aiAgentConfigHead = (AiAgentConfigHead)((Object)this.aiAgentConfigHeadService.getById((Serializable)((Object)id)));
        AiAgentConfigHeadVO aiAgentConfigHeadVO = new AiAgentConfigHeadVO();
        BeanUtils.copyProperties((Object)((Object)aiAgentConfigHead), (Object)((Object)aiAgentConfigHeadVO));
        List<AiAgentDataCollectConfigItem> aiAgentDataCollectConfigItemList = this.aiAgentDataCollectConfigItemService.selectByMainId(id);
        aiAgentConfigHeadVO.setAiAgentDataCollectConfigItemList(aiAgentDataCollectConfigItemList);
        List<AiAgentDataCleanConfigItem> aiAgentDataCleanConfigItemList = this.aiAgentDataCleanConfigItemService.selectByMainId(id);
        aiAgentConfigHeadVO.setAiAgentDataCleanConfigItemList(aiAgentDataCleanConfigItemList);
        List<AiAgentAppConfigItem> aiAgentAppConfigItemList = this.aiAgentAppConfigItemService.selectByMainId(id);
        aiAgentConfigHeadVO.setAiAgentAppConfigItemList(aiAgentAppConfigItemList);
        List<AiAgentResultConfigItem> aiAgentResultConfigItemList = this.aiAgentResultConfigItemService.selectByMainId(id);
        aiAgentConfigHeadVO.setAiAgentResultConfigItemList(aiAgentResultConfigItemList);
        return Result.ok((Object)((Object)aiAgentConfigHeadVO));
    }

    @PostMapping(value={"/chat"})
    public Result<?> agentQuery(@RequestBody AgnetCommonRequestPojo agnetCommonRequestDto, HttpServletRequest request) throws Exception {
        String redisKey = agnetCommonRequestDto.getAgentCode() + "_" + agnetCommonRequestDto.getBusinessType() + "_" + agnetCommonRequestDto.getBusinessId();
        if (!this.redisUtil.tryGetDistributedLock(AI_CHAT, redisKey, LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFiKRcsSTVBtk_2ef68e36", (String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            AgentLlmRequestPojo llmRequest = new AgentLlmRequestPojo();
            QuestionInfoPojo questionInfo = new QuestionInfoPojo();
            questionInfo.setQuestion(agnetCommonRequestDto.getQuestion());
            questionInfo.setQuestionQuerySchema(agnetCommonRequestDto.getQuestionQuerySchema());
            questionInfo.setQuestionSchema(agnetCommonRequestDto.getQuestionSchema());
            questionInfo.setBusinessId(agnetCommonRequestDto.getBusinessId());
            questionInfo.setBusinessNumber(agnetCommonRequestDto.getBusinessNumber());
            questionInfo.setBusinessType(agnetCommonRequestDto.getBusinessType());
            AiChatPojo chatChatConfig = new AiChatPojo();
            chatChatConfig.setQuestion(questionInfo);
            chatChatConfig.setFileList(agnetCommonRequestDto.getFileList());
            llmRequest.setAiChatPojo(chatChatConfig);
            AiAgentConfigHeadVO agentVo = this.aiAgentConfigHeadService.getByAgentCode(agnetCommonRequestDto.getAgentCode());
            if (null == agentVo) {
                throw new ELSBootException(agnetCommonRequestDto.getAgentCode() + "\u4e0d\u5b58\u5728");
            }
            String logHead = IdWorker.getIdStr();
            AgentMqUtil.sendHead(logHead, TenantContext.getTenant(), llmRequest, agentVo, null, false);
            List<AiAgentDataCollectConfigItem> aiAgentDataCollectConfigItemList = agentVo.getAiAgentDataCollectConfigItemList();
            JSONObject collectDataMap = DataCollectRunner.collect(llmRequest, aiAgentDataCollectConfigItemList);
            List<AiAgentDataCleanConfigItem> aiAgentDataCleanConfigItemList = agentVo.getAiAgentDataCleanConfigItemList();
            Map<String, String> questionSchemaMap = DataCleanRunner.clean(llmRequest, collectDataMap, aiAgentDataCleanConfigItemList);
            List<AiAgentAppConfigItem> aiAgentAppConfigItemList = agentVo.getAiAgentAppConfigItemList();
            Map<String, LlmResponsePojo> responsePojoMap = DataAppRunner.run(llmRequest, questionSchemaMap, aiAgentAppConfigItemList);
            List<AiAgentResultConfigItem> aiAgentResultConfigItemList = agentVo.getAiAgentResultConfigItemList();
            LlmResponsePojo llmResponsePojo = DataResultRunner.vote(llmRequest, responsePojoMap, aiAgentResultConfigItemList);
            AgentMqUtil.sendHead(logHead, TenantContext.getTenant(), llmRequest, agentVo, llmResponsePojo, true);
            AiChatResultLog log = new AiChatResultLog();
            log.setElsAccount(SysUtil.getLoginUser().getElsAccount());
            log.setBusinessId(questionInfo.getBusinessId());
            log.setBusinessNumber(questionInfo.getBusinessNumber());
            log.setBusinessType(questionInfo.getBusinessType());
            log.setBusinessName(questionInfo.getBusinessName());
            log.setQuestionInput(llmResponsePojo.getQuestionInput());
            log.setQuestionResult(llmResponsePojo.getResultText());
            log.setAppCode(agentVo.getAgentCode());
            this.aiChatResultLogService.add(log);
            Result result = Result.ok((Object)llmResponsePojo);
            return result;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(AI_CHAT, redisKey);
            AiEnhanceBeanHolder.remove();
        }
    }
}

