/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.helper;

import cn.hutool.core.collection.CollectionUtil;
import com.els.modules.ai.core.util.AiUtil;
import com.els.modules.ai.pojo.AiChatAppPojo;
import com.els.modules.ai.pojo.AiChatExamplarPojo;
import com.els.modules.ai.pojo.LlmRequestPojo;
import com.els.modules.ai.pojo.QuestionInfoPojo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AiChatPromptHelper {
    private static final Logger log = LoggerFactory.getLogger(AiChatPromptHelper.class);

    public List<List<AiChatExamplarPojo>> getFewShotExemplars(LlmRequestPojo llmRequest) {
        List exemplars = llmRequest.getChatExamplers();
        ArrayList<List<AiChatExamplarPojo>> results = new ArrayList<List<AiChatExamplarPojo>>();
        ArrayList shuffledList = new ArrayList(exemplars);
        Collections.shuffle(shuffledList);
        results.add(shuffledList.subList(0, Math.min(shuffledList.size(), exemplars.size())));
        return results;
    }

    public String buildSideInformation(LlmRequestPojo llmRequest) {
        String currentDate = llmRequest.getAiChatPojo().getCurrentDate();
        ArrayList sideInfos = Lists.newArrayList();
        sideInfos.add(String.format("CurrentDate=[%s]", currentDate));
        return String.join((CharSequence)",", sideInfos);
    }

    public String buildSchemaStr(LlmRequestPojo llmReq) {
        QuestionInfoPojo question = llmReq.getAiChatPojo().getQuestion();
        AiChatAppPojo aiChatAppPojo = llmReq.getAiChatAppPojo();
        String questionSchema = question.getQuestionSchema();
        Map questionSchemaMap = question.getQuestionSchemaMap();
        if (CollectionUtil.isNotEmpty((Map)questionSchemaMap) && questionSchemaMap.containsKey("questionSchema")) {
            return AiUtil.jsonTextFormat((String)questionSchemaMap.get("questionSchema"), aiChatAppPojo.getInputTextType());
        }
        return AiUtil.jsonTextFormat(questionSchema, aiChatAppPojo.getInputTextType());
    }
}

