/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ainpl.controller;

import cn.hutool.core.convert.Convert;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.ai.core.AiRequestService;
import com.els.modules.ainpl.vo.AiOrderCreationRequestDTO;
import com.els.modules.ainpl.vo.AiOrderCreationRunDTO;
import com.els.modules.ainpl.vo.AiOrderCreationSessionDTO;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"AI\u5927\u6a21\u578b\u5bf9\u8bdd"})
@RestController
@RequestMapping(value={"/aiOrderCreation"})
public class AiOrderCreationChatController {
    private static final Logger log = LoggerFactory.getLogger(AiOrderCreationChatController.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private AiRequestService aiRequestService;
    private static final String AI_ORDER_CREATION_EXEC = "srm:ai_order_creation:exec";
    private static final Long LOCK_EXPIRE_TIME = 30000L;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @PostMapping(value={"/chat"})
    public Result<?> query(@RequestBody AiOrderCreationRequestDTO requestDTO) throws Exception {
        AiOrderCreationSessionDTO aiSession = this.aiRequestService.runAiOrderCreationChat(requestDTO);
        return Result.ok((Object)aiSession);
    }

    @PostMapping(value={"/run"})
    public Result<?> run(@RequestBody AiOrderCreationRunDTO runDTO) throws Exception {
        String redisKey = runDTO.getAiSessionId();
        if (!this.redisUtil.tryGetDistributedLock(AI_ORDER_CREATION_EXEC, redisKey, LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFiKRcsSTVBtk_2ef68e36", (String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.aiRequestService.execAiOrderCreation(runDTO);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(AI_ORDER_CREATION_EXEC, redisKey);
        }
    }

    @GetMapping(value={"/modelTemplateList/{businessType}"})
    public Result<?> modelTemplateList(@PathVariable(value="businessType") String businessType) throws Exception {
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType(businessType);
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f\u3002"));
        TemplateHeadDTO templateHeadDTO = (TemplateHeadDTO)templateList.get(0);
        templateHeadDTO = this.invokeBaseRpcService.getTemplateConfig(templateHeadDTO.getElsAccount(), templateHeadDTO.getTemplateNumber(), "" + templateHeadDTO.getTemplateVersion());
        List templateConfigHeadList = templateHeadDTO.getTemplateConfigHeadList();
        List templateConfigItemList = templateHeadDTO.getTemplateConfigItemList();
        List templateConfigHeadDTOS = Convert.toList(TemplateConfigHeadDTO.class, (Object)templateConfigItemList);
        templateConfigHeadList.addAll(templateConfigHeadDTOS);
        templateConfigHeadList = templateConfigHeadList.stream().filter(x -> !x.getFieldName().contains("fbk")).collect(Collectors.collectingAndThen(Collectors.toMap(TemplateConfigHeadDTO::getFieldName, Function.identity(), (v1, v2) -> v1, LinkedHashMap::new), map -> new ArrayList(map.values())));
        return Result.ok((Object)templateConfigHeadList);
    }
}

