/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.agent.clean;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.modules.ai.core.agent.clean.AbstractCleanStrategy;
import com.els.modules.ai.entity.AiAgentDataCleanConfigItem;
import com.els.modules.ai.pojo.AgentLlmRequestPojo;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JavaScriptEngineCleanStrategy
extends AbstractCleanStrategy {
    private static final Logger log = LoggerFactory.getLogger(JavaScriptEngineCleanStrategy.class);

    @Override
    public String type() {
        return "JAVA_SCRIPT";
    }

    @Override
    public JSONObject doExecute(AgentLlmRequestPojo llmRequest, AiAgentDataCleanConfigItem config, JSONObject input) {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
        if (engine == null) {
            throw new RuntimeException("Nashorn script engine not found");
        }
        if (CharSequenceUtil.isEmpty((CharSequence)config.getItemConfig()) || null == input) {
            return input;
        }
        try {
            engine.put("input", input);
            engine.eval(config.getItemConfig());
            if (engine instanceof Invocable) {
                Invocable invocable = (Invocable)((Object)engine);
                Object result = invocable.invokeFunction("cleanFunction", input);
                if (result instanceof JSONObject) {
                    return (JSONObject)result;
                }
                if (result instanceof String) {
                    return JSON.parseObject((String)((String)result));
                }
                return JSON.parseObject((String)JSON.toJSONString((Object)result));
            }
        }
        catch (Exception e) {
            throw new ELSBootException("\u811a\u672c\u6267\u884c\u5f02\u5e38 | \u914d\u7f6ename:{} | \u9519\u8bef: {}", new String[]{config.getName(), e.getMessage()});
        }
        return input;
    }
}

