/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.barcode.entity.PurchaseBarcodeTemplateItem;
import com.els.modules.barcode.enumerate.ElsBarcodeFiledType;
import com.els.modules.barcode.mapper.PurchaseBarcodeTemplateItemMapper;
import com.els.modules.barcode.service.PurchaseBarcodeTemplateItemService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseBarcodeTemplateItemServiceImpl
extends BaseServiceImpl<PurchaseBarcodeTemplateItemMapper, PurchaseBarcodeTemplateItem>
implements PurchaseBarcodeTemplateItemService {
    @Autowired
    private PurchaseBarcodeTemplateItemMapper purchaseBarcodeTemplateItemMapper;

    @Override
    public List<PurchaseBarcodeTemplateItem> selectByMainId(String mainId) {
        return this.purchaseBarcodeTemplateItemMapper.selectByMainId(mainId);
    }

    @Override
    public List<PurchaseBarcodeTemplateItem> templateResolve(Map<String, String> map) {
        String[] itemArr;
        String designContent = map.get("designContent");
        List<Object> dbItem = Lists.newArrayList();
        String id = map.get("id");
        HashMap dbMap = Maps.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)id) && CollUtil.isNotEmpty((Collection)(dbItem = this.selectByMainId(id)))) {
            dbMap.putAll(dbItem.stream().collect(Collectors.toMap(x -> x.getDesignContent(), y -> y)));
        }
        ArrayList<PurchaseBarcodeTemplateItem> itemList = new ArrayList<PurchaseBarcodeTemplateItem>();
        for (String item : itemArr = designContent.replaceAll("\r", "").replaceAll("\n", "").split("\\);")) {
            String head = item.substring(item.indexOf("."), item.indexOf("("));
            String designType = head.substring(head.lastIndexOf("_") + 1);
            if ("INIT".equals(designType) || "INITA".equals(designType)) continue;
            PurchaseBarcodeTemplateItem templateItem = new PurchaseBarcodeTemplateItem();
            if ("BKIMG".equals(designType) || "MODE".equals(designType) || "STYLEA".equals(designType)) {
                templateItem.setDesignContent(item + ")");
                templateItem.setElementType(designType);
                templateItem.setElementContent(item.substring(item.indexOf("(") + 1, item.length() - 1).replaceAll("\"", ""));
            } else {
                String[] arr = item.substring(item.indexOf("(") + 1, item.length() - 1).split(",");
                templateItem.setDesignContent(item + ")");
                templateItem.setElementType(designType);
                templateItem.setElementCoordinates(arr[0] + "," + arr[1]);
                templateItem.setElementWidth(arr[2]);
                templateItem.setElementHeight(arr[3]);
                templateItem.setElementContent(arr[arr.length - 1].replaceAll("\"", ""));
            }
            if (dbMap.containsKey(templateItem.getDesignContent())) {
                PurchaseBarcodeTemplateItem dbItemRow = (PurchaseBarcodeTemplateItem)((Object)dbMap.get(templateItem.getDesignContent()));
                templateItem.setFiledType(dbItemRow.getFiledType());
            } else {
                templateItem.setFiledType(ElsBarcodeFiledType.FIXED.value());
            }
            itemList.add(templateItem);
        }
        return itemList;
    }
}

